const printSmartlingFormat = require('./print-smartling-format.js');

const { diffObjects } = require('./object-operations.js');
const { runLints } = require('./linters.js');
const { smartlingToPropSchema } = require('./yaml-convert.js');
const { removeNoTranslate } = require('./utils.js');
const { loadYaml } = require('./utils.js');

function newTranslations(firstYamlObj, secondYamlObj) {
  let diffed = diffObjects(removeNoTranslate(firstYamlObj), secondYamlObj);
  runLints(diffed);
  return diffed;
}

/**
 * Prints a smartling file format
 * @param yamlObj Property Schema is expected
 * @returns {Array.<string>}
 * smartlingFileFormat()
 */
function toSmartlingFormat(yamlObj) {
  yamlObj = removeNoTranslate(yamlObj);
  runLints(yamlObj);
  let yamlStr = printSmartlingFormat(yamlObj);
  loadYaml(yamlStr); // Confirming the Yaml file is well formed
  return yamlStr;
}

function fromSmartlingFormat(origYamlObj) {
  let yamlObj = smartlingToPropSchema(origYamlObj);
  runLints(yamlObj);
  return yamlObj;
}

module.exports = {
  newTranslations,
  toSmartlingFormat,
  fromSmartlingFormat
};
