const { assert } = require('chai');
const { describe, it } = require('mocha');
const { newTranslations, toSmartlingFormat } = require('./../src/yaml-icu.js');

describe('Confirm NoTranslate are being removed', function () {
  it('Make sure nulls are not printed with null value', function () {
    const res = newTranslations({
      a: {
        phrase: 'a phrase',
        noTranslate: true
      },
      b: {
        phrase: 'another phrase'
      },
      c: {
        phrase: '{var, plural, one {one} other {other}}',
        noTranslate: true
      },
      d: {
        phrase: '{var, plural, one {one} other {other}}'
      }
    }, {a: null});

    const expectedResult = {
      b: {
        phrase: 'another phrase'
      },
      d: {
        phrase: '{var, plural, one {one} other {other}}'
      }
    };
    assert.deepEqual(res, expectedResult);
  });

  it('Confirm Submit is returning expected value', function () {
    const res = toSmartlingFormat({
      a: {
        phrase: 'a phrase',
        noTranslate: true
      },
      b: {
        phrase: 'another phrase'
      },
      c: {
        phrase: '{var, plural, one {one} other {other}}',
        noTranslate: true
      },
      d: {
        phrase: '{var, plural, one {one} other {other}}'
      }
    });

    const expectedResult =
`b: another phrase
d:
  one: one
  other: other
# smartling.sltrans = notranslate
pluralKeys:
  d: var
# smartling.sltrans = translate`;

    assert.deepEqual(res, expectedResult);
  });
});
