const { assert } = require('chai');
const { describe, it } = require('mocha');
const { removeNoTranslate, printYamlWithNullsRemoved } = require('./../src/utils.js');

describe('Printing YAML with Nulls Removed', function () {  
  it('Make sure nulls are not printed with null value', function () {
    const res = printYamlWithNullsRemoved({a: null});

    assert.strictEqual(res, 'a:\n');
  });

  it('Should respect noTranslate property in objects', function () {
    let result = removeNoTranslate(
        {a: {phrase: 'new'}, d: {noTranslate: true}, b: {phrase: 'hi'}}
    );
    assert.deepEqual(result, {a: {phrase: 'new'}, b: {phrase: 'hi'}});
  });
});
