var fs = require('fs');
var path = require('path');
var request = require('request');

var args = process.argv;
var transformedJSON = {
  "smartling" : {
    "translate_paths": {
    	"path":"*",
    	"key":"{*}"
    },
    "placeholder_format_custom": 'NONE',
    "variants_enabled": "true"
    }
};

var filePath = process.argv[2];
var fileName = path.basename(filePath);
var dirName = path.dirname(filePath);
var locale = path.basename(dirName);

var jsonFile = JSON.parse(fs.readFileSync(filePath));
Object.keys(jsonFile['en']).forEach((key) => {
  // transformedJSON[key] = {
  //   key: key,
  //   translation: jsonFile[key]
  // };
  transformedJSON[key] = jsonFile['en'][key];
});

var destFilePath = path.join(dirName, locale + '-' + fileName);
fs.writeFileSync(destFilePath, JSON.stringify(transformedJSON, null, 2));
console.log('Saved: ' + destFilePath);
// return;

var projectId = '18256d1bd';
var localeMapping = {
	'de': 'de-DE',
	'es-ES': 'es-ES',
	'fr': 'fr-FR',
	'it': 'it-IT',
	'ja': 'ja-JP',
	'ko': 'ko-KR',
	'pl': 'pl-PL',
	'pt-BR': 'pt-BR',
	'ru': 'ru-RU',
	'tr': 'tr-TR',
	'zh-TW': 'zh-TW'
};

if (!localeMapping[locale]) {
	throw new Error(`Freakout. Locale: ${localeId} fileName: ${fileName}`);
}

var localeId = localeMapping[locale];
var req = request.post({
	url: `http://localhost:9292/smartling-v2-proxy/files-api/v2/projects/${projectId}/locales/${localeId}/file/import`,
	qs: {
		fileUri: 'translations.json',
		fileType: 'json',
		overwrite: true,
		translationState: 'POST_TRANSLATION'
	}
}, function (error, response, body) {
	if (!error && response.statusCode === 200) {
		console.log('Finished Import Successfully');
	} else {
		console.log(response);
		console.log('Finish Import Failure');
	}
	console.log(JSON.stringify(JSON.parse(body), null, 2));
});

var form = req.form();
form.append('file', JSON.stringify(transformedJSON), {
	filename: fileName,
	contentType: 'text/plain'
});


