var fs = require('fs');
var path = require('path');
var request = require('request');

var args = process.argv;

var filePath = process.argv[2];
var fileName = path.basename(filePath);
var dirName = path.dirname(filePath);
var locale = path.basename(dirName);
var fileContents = fs.readFileSync(filePath);

var projectId = 'd3ae54798';
var localeMapping = {
	'de': 'de-DE',
	'es-ES': 'es-ES',
	'fr': 'fr-FR',
	'it': 'it-IT',
	'ja': 'ja-JP',
	'ko': 'ko-KR',
	'pl': 'pl-PL',
	'pt-BR': 'pt-BR',
	'ru': 'ru-RU',
	'tr': 'tr-TR',
	'zh-TW': 'zh-TW'
};

if (!localeMapping[locale]) {
	throw new Error(`Freakout. Locale: ${localeId} fileName: ${fileName}`);
}

var localeId = localeMapping[locale];
var req = request.post({
	url: `http://localhost:9292/smartling-v2-proxy/files-api/v2/projects/${projectId}/locales/${localeId}/file/import`,
	qs: {
		fileUri: 'UIStrings.resx',
		fileType: 'resx',
		overwrite: true,
		translationState: 'POST_TRANSLATION'
	}
}, function (error, response, body) {
	if (!error && response.statusCode === 200) {
		console.log('Finished Import Successfully');
	} else {
		console.log(response.body);
		console.log('Finish Import Failure');
	}
	console.log(JSON.stringify(JSON.parse(body), null, 2));
});

var form = req.form();
form.append('file', fileContents, {
	filename: fileName,
	contentType: 'text/plain'
});
