

Notes
==========================

This is a forked lib from [smartling-sdk](https://github.com/hightail/smartling-sdk). This is meant to be used by [grunt-smartling-sdk-twitch](https://git-aws.internal.justin.tv/i18n/grunt-smartling-sdk-twitch)

Main differences:
- Adds Get-Translations endpoint support
- Adds uploadContent support which uploads a file content string instead of a file
- Adds projectName param which is used by [I18n-Service](https://git-aws.internal.justin.tv/i18n/i18n-service/) to avoid passing tokens

The following is the original README.

smartling-sdk [![Build Status](https://travis-ci.org/hightail/smartling-sdk.svg?branch=master)](https://travis-ci.org/hightail/smartling-sdk)
==========================

# NodeJS SDK for Smartling

Promised based SDK for the [Smartling Translation API](https://docs.smartling.com/display/docs/Smartling+Translation+API)

Supported functions:
* list
* status
* get
* upload
* rename
* delete

## How to use smartling-sdk

Install smartling-sdk:

```
$ npm install smartling-sdk
```

Require and use it:

```
var SmartlingSdk = require("smartling-sdk");

//Create a new sdk object with your Smartling information
var sdk = new SmartlingSdk(SmartlingSdk.API_BASE_URLS.SANDBOX, 'your-smartling-api-key', 'your-smartling-project-id');

// Get a list of available files
sdk.list()
  .then(function(response) {
    console.log(response);
  })
  .fail(function(err) {
    // an error has occurred
  });

// Upload a file
sdk.upload('./path/to/some-file.json', 'some-file', 'json')
  .then(function(response) {
    // File uploaded successfully
    console.log(response);
  })
  .fail(function(err) {
    // an error has occurred
  });

// Get a status of a file
sdk.status('some-file', 'en')
  .then(function(statusInfo) {
    console.log(statusInfo);
  })
  .fail(function(err) {
    // an error has occurred
  });


// Get a file
sdk.get('some-file')
  .then(function(fileContents) {
    // File retrieved successfully
    console.log(fileContents);
  })
  .fail(function(err) {
    // an error has occurred
  });

// Rename a file
sdk.rename('some-file', 'some-file-with-a-new-name')
  .then(function(response) {
    //File renamed successfully
  })
  .fail(function(err) {
    //an error has occurred
  });

// Delete a file
sdk.delete('some-file-with-a-new-name')
  .then(function(response) {
    //File deleted successfully
  })
  .fail(function(err) {
    //an error has occurred
  });
```

## More documentation
For more in depth documentation look at the comments in [smartling.js](https://github.com/hightail/smartling-sdk/blob/master/smartling.js)

## How to test smartling-sdk

###Unit testing & Code coverage
Unit tests run against prerecorded API responses via [node-replay](https://github.com/assaf/node-replay).

Unit test configuration is located in ~/test/config/unit.json but you don't need to modify it since the responses are prerecorded.

To run the unit tests and code coverage:

```
npm test
```

###Integration testing
Integration tests will run against the real Smartling API.

To run the integration tests first you will need to add your *apiKey* and *projectId* to ~/test/config/integration.json

```
{
  "apiBaseUrl": "https://sandbox-api.smartling.com/v1",
  "apiKey":     "your-api-key",
  "projectId":  "your-project-id"
}
```

Then you can run the script:
```
npm run integration
```

