const fs = require('fs');
const parse = require('csv-parse/lib/sync');
const jsYaml = require('js-yaml');


let csvFile = parse(fs.readFileSync('./original-assets/2017-06-09_phrases.csv', {encoding: 'utf8'}));

let obj = {};
csvFile.forEach((record) => {
  let id = record[0];
  let phrase = record[1];
  let obsolete = record[2];
  let usedInJs = record[5];
  let templateKey = record[8];

  if (obsolete === 't') {
    return;
  }
  
  obj[id] = {
    id,
    phrase,
    usedInJs,
    templateKey
  };
});

fs.writeFileSync('./phrases.yaml', jsYaml.dump(obj));

