const fs = require('fs');
const parse = require('csv-parse/lib/sync');
const jsYaml = require('js-yaml');

let translations = {};
let fileNames = fs.readdirSync('./split-by-locale');
let transformedTranslations = {};

fileNames.map((fileName) => {
	if (!fileName.endsWith('.csv')) { return; }

	console.log('processing '+ fileName);
	let csvFile = parse(fs.readFileSync('./split-by-locale/' + fileName, {encoding: 'utf8'}));
	console.log('done reading');
	
	let translations = {};
	let tmpLocale;
	csvFile.forEach((record) => {
		let locale = record[4];
		tmpLocale = locale;
		let id = record[2];
		let version = parseInt(record[1], 10);

		if (!translations[id] || translations[id].version < version) {
			translations[id] = {
				text: record[3],
				version: version
			};
		}

		// console.log(Object.keys(translations['ar']).length);
	});

	if (!transformedTranslations[tmpLocale]) {
		transformedTranslations[tmpLocale] = {};
	}
	
	Object.keys(translations).forEach((key) => {
		transformedTranslations[tmpLocale][key] = translations[key]['text'];
	});
	
});

fs.writeFileSync('./translations.yaml', jsYaml.dump(transformedTranslations));
