var fs = require('fs')
    , util = require('util')
    , stream = require('stream')
    , es = require('event-stream')
    , parse = require('csv-parse/lib/sync');


var lineNr = 0;

var s = fs.createReadStream('./original-assets/2017-06-09_trans_phrases.csv')
    .pipe(es.split())
    .pipe(es.mapSync(function(line){

        // pause the readstream
        s.pause();

        try {
	    	let record = parse(line)[0];
			let locale = record[4];

			let fileName = './split-by-locale/' + locale + '.csv';

			fs.appendFileSync(fileName, line + '\n');
		} catch (err) {
			console.log(err);
			console.log(line);
		}

        // resume the readstream, possibly from a callback
        s.resume();
    })
    .on('error', function(error){
        console.log('Error while reading file.' + error);
    })
    .on('end', function(){
        console.log('Read entire file.')
    })
);