ElasticSearchCluster
====================

Scripts to build an AMIs and related for the EC2 Elastic Search Cluster

#Current status
- Creates an ami and a launch config that once booted will have huge 10TB drives mounted.

#Current steps to get this working

- Run `packer build -var branch=$(git symbolic-ref --short HEAD) packer.json` from bash to build new ami
- Edit splashmountain-es.json and increment version
- Run `python ./buildLaunchConfigs.py splashmountain-es.json KEYPAIR AMIID` for example `python ./buildLaunchConfigs.py splashmountain-es.json lumberjack ami-b13d1f81`
- Launch ASG in EC2 console
  - Navigate to https://us-west-2.console.aws.amazon.com/ec2/autoscaling/home?region=us-west-2#AutoScalingGroups:view=details and click `Create Auto Scaling Group`
  - Pick the launch configuration you careted with `buildLaunchConfigs.py` click `Next`
  - Verify that you are in the Production VPC and add all the subnets click `Next` through the screens to the end (optionally) editing the settings
  - Click `Review` then Click `Create Auto Scaling Group` once you have reviewed the settings
  - Your instance(s) should launch \o/
  

#TODO
- More automation of the above steps
- Move settings from inside packer.json to production and development settings files
- Setup discovery of other Elastic Search nodes - probably using https://github.com/elastic/elasticsearch-cloud-aws
- Configure Elastic Search
- Install Marvel or Statsd to monitor the cluster

