package pgcsvcollector

// Postgres CSV log format from http://www.postgresql.org/docs/9.3/static/runtime-config-logging.html#RUNTIME-CONFIG-LOGGING-CSVLOG
// CREATE TABLE postgres_log
// (
//   log_time timestamp(3) with time zone,
//   user_name text,
//   database_name text,
//   process_id integer,
//   connection_from text,
//   session_id text,
//   session_line_num bigint,
//  7 command_tag text,
//   session_start_time timestamp with time zone,
//   virtual_transaction_id text,
//   transaction_id bigint,
// 11  error_severity text,
//   sql_state_code text,
// 13  message text,
//   detail text,
//   hint text,
//   internal_query text,
//   internal_query_pos integer,
//   context text,
//   query text,
//   query_pos integer,
//   location text,
//   application_name text,
//   PRIMARY KEY (session_id, session_line_num)
// );

import (
	"encoding/csv"
	"fmt"
	"os"
	"pgtools/pgquery"
)

type PgCsvCollector struct {
	Infile  string "Input logfile, in postgresql csv format"
	queries chan pgquery.PGQuery
}

func NewPgCsvCollector(infile string) *PgCsvCollector {
	cc := PgCsvCollector{
		infile,
		make(chan pgquery.PGQuery, 10000),
	}
	return &cc
}

func (pc *PgCsvCollector) GetQueryChannel() chan pgquery.PGQuery {
	return pc.queries
}

func (pc *PgCsvCollector) Run() {
	csvfile, err := os.Open(pc.Infile)
	if err != nil {
		fmt.Println(err)
		return
	}

	defer csvfile.Close()

	reader := csv.NewReader(csvfile)

	count := 0
	for {
		record, _ := reader.Read()
		query := pgquery.NewPGQueryFromCsv(record)
		pc.queries <- query
		count++
	}
}
