// Filters varnish logs generated by our application servers

package varnishappfilter

import (
	"eventfilter/event"
	"log"
)

type VarnishAppFilter struct {
	eventQueue      chan event.Event
	isFiltered      bool
	inputCount      int64
	lastInputCount  int64
	outputCount     int64
	lastOutputCount int64
}

func NewVarnishAppFilter(eventQueue chan event.Event, isFiltered bool) VarnishAppFilter {
	return VarnishAppFilter{
		eventQueue,
		isFiltered,
		0,
		0,
		0,
		0,
	}
}

func LogRequest(e event.Event) bool {
	m := e.Data["method"]
	switch m {
	case "POST", "PUT", "DELETE":
		return true
	}
	return false
}

func (vaf *VarnishAppFilter) Run(output_queue chan event.Event) {
	for {
		event := <-vaf.eventQueue
		vaf.inputCount++
		// event.Data["added"] = event.Data["id"] + "b"
		if !vaf.isFiltered || LogRequest(event) {
			vaf.outputCount++
			output_queue <- event
		}
	}
}

func (vaf *VarnishAppFilter) DumpStatus() {
	log.Println("VarnishAppFilter Input:", vaf.inputCount)
	log.Println("VarnishAppFilter Input in interval:", vaf.inputCount-vaf.lastInputCount)
	log.Println("VarnishAppFilter Output:", vaf.outputCount)
	log.Println("VarnishAppFilter Output in interval:", vaf.outputCount-vaf.lastOutputCount)

	vaf.lastInputCount = vaf.inputCount
	vaf.lastOutputCount = vaf.outputCount
}
