package fileoutput

import (
	"eventfilter/event"
	"fmt"
	"os"
)

type FileOutput struct {
	outputQueue chan event.Event
	filename    string
}

func NewFileOutput(outputQueue chan event.Event, filename string) FileOutput {
	return FileOutput{
		outputQueue,
		name,
	}
}

func (fo *FileOutput) Run() {
	f, err := os.Create(filename)
	if err != nil {
		fmt.Println(err)
	}
	defer f.Close()
	for {
		event := <-fo.outputQueue
		out := fmt.Sprint(event.Data)
		f.WriteString(out)
		f.WriteString("\n")
		f.Flush()
	}
}
