package logstashoutput

import (
	"encoding/json"
	"eventfilter/event"
	"fmt"
	"log"
	"net"
	"time"
)

type LogstashOutput struct {
	outputQueue chan event.Event
	address     string
	isUDP       bool
	count       int64
	lastCount   int64
}

func NewLogstashOutput(outputQueue chan event.Event, address string, isUDP bool) LogstashOutput {
	return LogstashOutput{
		outputQueue,
		address,
		isUDP,
		0,
		0,
	}
}

func (o *LogstashOutput) Run() {
	if o.isUDP {
		conn, err := net.Dial("udp", o.address)
		if err != nil {
			log.Fatal(err)
		}
		defer conn.Close()
		for {
			event := <-o.outputQueue
			o.count++
			out, err := json.Marshal(event.Data)
			if err != nil {
				log.Fatal(err)
			}
			conn.SetDeadline(time.Now().Add(10 * time.Second))
			n, err := conn.Write(out)
			if err != nil {
				log.Fatal(n, err)
			}
		}
	} else {
		conn, err := net.Dial("tcp", o.address)
		if err != nil {
			log.Fatal(err)
		}
		defer conn.Close()
		for {
			event := <-o.outputQueue
			o.count++
			out, err := json.Marshal(event.Data)
			if err != nil {
				log.Fatal(err)
			}
			conn.SetDeadline(time.Now().Add(10 * time.Second))
			n, err := conn.Write(out)
			if err != nil {
				log.Fatal(n, err)
			}
			fmt.Fprint(conn, "\n")
		}
	}
}

func (o *LogstashOutput) DumpStatus() {
	log.Println("LogStashOutput Output: ", o.count)
	log.Println("LogStashOutput Output in interval:", o.count-o.lastCount)
	o.lastCount = o.count
}
