package syslogoutput

import (
	"eventfilter/event"
	"fmt"
	"log"
	"log/syslog"
)

type SyslogOutput struct {
	outputQueue chan event.Event
	name        string
}

func NewSyslogOutput(outputQueue chan event.Event, name string) SyslogOutput {
	return SyslogOutput{
		outputQueue,
		name,
	}
}

func (so *SyslogOutput) Run() {
	logwriter, err := syslog.New(syslog.LOG_INFO, so.name)
	if err != nil {
		log.Fatal("error:", err)
	}
	for {
		event := <-so.outputQueue
		out := fmt.Sprint(event.Data)
		logwriter.Write([]byte(out))
	}
}
