// Connects to a postgres database and gets status information.
//

package pgstatus

import (
	"database/sql"
	"fmt"

	_ "github.com/lib/pq"
)

// import _ "github.com/lib/pq"

// type BackendChecker interface {
// 	Check() error
// }

// func NewBackend(host string, port int, user string, pass string, database string) BackendChecker {
// 	dsn := fmt.Sprintf("sslmode=disable host=%v port=%v user='%v' password='%v' dbname='%v'",
// 		host, port, user, pass, database)
// 	be := new(backend)
// 	be.dsn = dsn
// 	return be
// }

// type backend struct {
// 	dsn string
// }

// func (be *backend) Check() error {
// 	db, err := sql.Open("postgres", be.dsn)
// 	if err != nil {
// 		//sm.MarkPortDown(be.port, "Unable to connect")
// 		return err
// 	}
// 	defer db.Close()
// 	rows, err := db.Query("select 1")
// 	if err != nil {
// 		//sm.MarkPortDown(be.port, "Unable to query")
// 		return err
// 	}
// 	defer rows.Close()
// 	for rows.Next() {
// 		// XXX AGB: Check result? 2015-01-06
// 	}
// 	return nil
// }

var (
	dsn string
)

type DBChecker interface {
	Connect() error
	Check() error
}

type MasterDBChecker struct {
	db                *sql.DB
	replica_whitelist []string
}

func NewMasterDBChecker() MasterDBChecker {
	c := MasterDBChecker{}

	c.Connect()
	return c
}

func (c *MasterDBChecker) Connect() error {
	// FIXME: Close properly in case of failure
	var err error
	dsn := fmt.Sprintf("sslmode=disable host=%v user='%v' dbname='%v'",
		"/var/run/postgresql", "postgres", "postgres")
	c.db, err = sql.Open("postgres", dsn)
	if err != nil {
		fmt.Println("Error opening", err)
		return err
	}
	return nil
}

type PGStatReplicationRow struct {
	usename         string
	client_addr     string
	client_hostname string
	sent_location   string
	write_location  string
	flush_location  string
	replay_location string
}

func (c *MasterDBChecker) checkReplication() error {
	rows, err := c.db.Query("SELECT usename FROM pg_stat_replication")
	// rows, err := c.db.Query("SELECT usename, client_addr, client_hostname, sent_location, write_location, flush_location, replay_location FROM pg_stat_replication")
	if err != nil {
		fmt.Println(err)
		return err
	}
	defer rows.Close()

	cols, _ := rows.Columns()
	fmt.Println(cols)

	// hosts := []PGStatReplicationRow
	r := new(PGStatReplicationRow)
	for rows.Next() {
		err := rows.Scan(&r.usename)
		if err != nil {
			fmt.Println(err)
			return err
		}
		fmt.Println(r)

	}

	// Compare sent locations vs master WAL location

	// usename should be replication for servers from the approved list
	// flag any unusual replication lag
	// Make sure all replication servers are from whitelist
	// Test all hosts in the lb_replica list to see if they are alive
	//   (check other monitors/direct connect)
	// Flag all localhost replication connections

	return nil
}

func (c *MasterDBChecker) Check() error {
	return c.checkReplication()

	// rows, err := c.db.Query("select pg_current_xlog_location()")
	// if err != nil {
	// 	fmt.Println(err)
	// }
	// cols, _ := rows.Columns()
	// fmt.Println(cols)
	// defer rows.Close()
	// var pg_current_xlog_location string
	// for rows.Next() {
	// 	err := rows.Scan(&pg_current_xlog_location)
	// 	if err != nil {
	// 		fmt.Println(err)
	// 		return err
	// 	}
	// 	fmt.Println(pg_current_xlog_location)
	// }
	// return nil
}

func RunCollector() {
	fmt.Println("Running a collector")
	dsn := fmt.Sprintf("sslmode=disable host=%v user='%v' dbname='%v'",
		"/var/run/postgresql", "postgres", "postgres")
	db, err := sql.Open("postgres", dsn)
	if err != nil {
		fmt.Println("Error opening", err)
		return
	}
	defer db.Close()

	rows, err := db.Query("select pg_current_xlog_location()")
	if err != nil {
		fmt.Println(err)
	}
	cols, _ := rows.Columns()
	fmt.Println(cols)
	defer rows.Close()
	var pg_current_xlog_location string
	for rows.Next() {
		err := rows.Scan(&pg_current_xlog_location)
		if err != nil {
			fmt.Println(err)
		}
		fmt.Println(pg_current_xlog_location)
	}
}
