#
# Provision everything needed to develop this project.
# This is a superset of the things in .manta.json - if you edit one of these,
# there is a good chance that you need to edit the other.
#
# This file is cribbed from Tarrant's not-brigade setup.
#

apt-get update

# Manta is used for building for production deployment
apt-get install -y manta

#
# Download and install go.
#
wget -cq https://storage.googleapis.com/golang/go1.4.2.linux-amd64.tar.gz
echo \"5020af94b52b65cc9b6f11d50a67e4bae07b0aff  go1.4.2.linux-amd64.tar.gz\" | sha1sum --check
tar -C /usr/local -xzf go1.4.2.linux-amd64.tar.gz

#
# Set up the go workspace.
#
mkdir -p /go
mkdir -p /go/src
mkdir -p /go/pkg
mkdir -p /go/bin
chown vagrant:vagrant /go/ /go/src/ /go/bin/ /go/pkg/

echo '
export PATH="/usr/local/go/bin:/go/bin/:$PATH"
export GOPATH="/go"
' >> /home/vagrant/.profile

source /home/vagrant/.profile

# Install git and mercurial to download packages.
apt-get -y install git mercurial

# In vmware we can't use chown -R because
# /go/src/git.internal.justin.tv/<project_name> is already mounted from the
# host system.

# Go modules that we use for development only.
sudo -u vagrant -i go get github.com/golang/lint/golint
sudo -u vagrant -i go get code.google.com/p/go.tools/cmd/goimports
sudo -u vagrant -i go get github.com/tools/godep

#
# Project-specific setup
#

# libpcap-dev is necessary (for postgres packet capture)
apt-get install -y libpcap-dev
apt-get install -y varnish
# FIXME: Install postgres