package main

import (
	"encoding/json"
	"flag"
	"log"
	"net"
	"os"
)

var configFile = flag.String("config", "config.json", "config file path")

type ListenerConfig struct {
	Port int    `json:"port"`
	Type string `json:"type"`
}

type LogstashConfig struct {
	Addr    string `json:"addr"`
	Workers int    `json:"workers"`
}

type S3Config struct {
	Bucket  string `json:"bucket"`
	Workers int    `json:"workers"`
}

type Config struct {
	Listeners []ListenerConfig `json:"listeners"`
	Logstash  LogstashConfig   `json:"logstash"`
	S3        S3Config         `json:"s3"`
}

func mustParseConfig() Config {
	var cfg Config

	f, err := os.Open(*configFile)
	if err != nil {
		log.Fatal(err)
	}
	defer f.Close()

	if err := json.NewDecoder(f).Decode(&cfg); err != nil {
		log.Fatal(err)
	}

	if _, err := net.ResolveTCPAddr("tcp", cfg.Logstash.Addr); err != nil {
		log.Fatalf("invalid logstash addr: %s", err)
	}

	return cfg
}
