package main

import (
	"io"
	"log"
	"net"
	"time"
)

// output to logstash

type LogstashWriter struct {
	addr string
	in   <-chan []byte
	conn net.Conn
}

var logstashStats = NewStatsLogger("logstash")

func retryDial(addr string) net.Conn {
	for {
		log.Printf("logstash writer attempting to dial: %s", addr)
		if conn, err := net.DialTimeout("tcp", addr, 15*time.Second); err != nil {
			log.Printf("failed to dial %s: %s, retrying in 1s", addr, err)
			time.Sleep(1 * time.Second)
		} else {
			return TimeoutConn(conn, 5*time.Second)
		}
	}
}

func writeMsg(w io.Writer, msg []byte) error {
	if _, err := w.Write(msg); err != nil {
		return err
	} else if _, err := w.Write([]byte{'\n'}); err != nil {
		return err
	}
	return nil
}

func WriteToLogstash(addr string, in <-chan []byte) {

	conn := retryDial(addr)
	for msg := range in {
		// keep retrying the same message on errors, with redials
		for {
			if err := writeMsg(conn, msg); err != nil {
				log.Printf("logstash write to %s failed: %s, redialing in 1 s", conn.RemoteAddr(), err)
				conn.Close()
				time.Sleep(1 * time.Second)
				conn = retryDial(addr)
			} else {
				logstashStats.Add("ship", 1)
				logstashStats.Add("bytes", int64(len(msg)+1))
				break
			}
		}
	}
}
