package main

import (
	"net"
	"time"
)

type timeoutConn struct {
	net.Conn
	timeout time.Duration
}

func (c *timeoutConn) Write(buf []byte) (int, error) {
	n, err := c.Conn.Write(buf)
	if err != nil {
		return n, err
	}

	return n, c.SetDeadline(time.Now().Add(c.timeout))
}

func (c *timeoutConn) Read(buf []byte) (int, error) {
	n, err := c.Conn.Read(buf)
	if err != nil {
		return n, err
	}

	return n, c.SetDeadline(time.Now().Add(c.timeout))
}

func TimeoutConn(conn net.Conn, timeout time.Duration) net.Conn {
	return &timeoutConn{
		Conn:    conn,
		timeout: timeout,
	}
}
