# nfconvert #
Tools for converting nfcapd files.

This has two commands:

**nfannounce** identifies files in S3 that need to be converted from
raw format to .json.gz format. It's designed for a single execution;
when run, it'll identify all the files that exist in raw form in S3 (at
`s3://ids-netflows/data/raw/*`), then for each one, it will push a
message into an SQS queue (`'ids-netflow-conversions'`), marking them
for processing.

**nfconvert** converts files from raw nfcapd format into gzipped
JSON. It's a long-running daemon process; once run, it will listen to
the SQS queue `'ids-netflow-conversions'`, polling once per 10
seconds. If it gets a message from SQS, it'll stream down the file
from S3, parsing it and writing the results into a gzipped JSON format
that it will ship back up to S3 at `s3://ids-netflows/data/json/*`.

It's safe to have many `nfconvert` processes running. Work should not
get duplicated, since reads from SQS are atomic.

Multiple `nfannounce` processes will probably cause duplicated
messages to enter the queue, which would cause repeated work. The work
is idempotent, though, so this is merely inefficient and shouldn't
cause any more serious problems than wasted time.

