package main

import (
	"bytes"
	"encoding/json"
	"flag"
	"log"
	"os"

	"compress/gzip"

	"code.justin.tv/ids/nfconvert/parse"
)

func main() {
	var filename string
	flag.StringVar(&filename, "filename", "", "nfdump file")
	var outputfname string
	flag.StringVar(&outputfname, "output", "", "file to write to")
	flag.Parse()

	f, err := os.Open(filename)
	if err != nil {
		log.Fatal(err)
	}
	var scanner parse.RecordScanner
	if err = scanner.Init(f, filename); err != nil {
		log.Fatal(err)
	}

	// map a closure over the ouptut file
	out, err := os.Create(outputfname)
	if err != nil {
		log.Fatal(err)
	}
	defer out.Close()

	var buffer bytes.Buffer
	gzBuffer := gzip.NewWriter(&buffer)
	newline := []byte{'\n'}
	err = scanner.Map(func(r *parse.Record) error {
		b, err := json.Marshal(r.Abbreviate())
		if err != nil {
			return err
		}
		gzBuffer.Write(b)
		gzBuffer.Write(newline)
		return nil
	})
	if err != nil {
		log.Fatal(err)
	}
	gzBuffer.Close()
	out.Write(buffer.Bytes())
}
