package main

// Server listening on an SQS queue to search through nfcapd files
import (
	"flag"
	"log"
	"sync"
	"time"

	"code.justin.tv/ids/nfconvert/query"

	_ "expvar"
	_ "net/http/pprof"

	"github.com/crowdmob/goamz/aws"
)

const (
	sqsPollInterval = 2 * time.Second
)

func main() {
	var (
		secret        string
		access        string
		token         string
		collectorAddr string
		n             int
	)
	flag.StringVar(&secret, "secret-key", "", "aws_secret_access_key")
	flag.StringVar(&access, "access-key", "", "aws_access_key_id")
	flag.StringVar(&token, "token", "", "aws_secret_token")
	flag.StringVar(&collectorAddr, "collector", "localhost:23456", "address of collector to send results to")
	flag.IntVar(&n, "n", 1, "number of workers to spawn")
	flag.Parse()

	auth, err := aws.GetAuth(access, secret, token, time.Now().Add(time.Hour*1))
	if err != nil {
		log.Fatal(err)
	}

	log.Printf("launching with access key id %s\n", auth.AccessKey)

	log.Println("making workers")
	i := 0
	wg := sync.WaitGroup{}
	for i < n {
		wg.Add(1)
		log.Println("adding one worker")
		go func() {
			log.Println("worker starting")
			query.Work(auth, collectorAddr)
			wg.Done()
			log.Println("worker done")
		}()
		i += 1
	}
	wg.Wait()
}
