package main

import "code.justin.tv/ids/nfconvert/parse"

// implements container/heap

var HeapMaxSize = 500

type FlowHeap []*parse.Record

func (h FlowHeap) Len() int           { return len(h) }
func (h FlowHeap) Less(i, j int) bool { return h[i].Base.BytesIn < h[j].Base.BytesIn }
func (h FlowHeap) Swap(i, j int)      { h[i], h[j] = h[j], h[i] }

func (h *FlowHeap) Push(x interface{}) {
	*h = append(*h, x.(*parse.Record))
}

func (h *FlowHeap) Pop() interface{} {
	old := *h
	n := len(old)
	x := old[n-1]
	*h = old[0 : n-1]
	return x
}

func (h *FlowHeap) Full() bool {
	return len(*h) >= HeapMaxSize
}
