variable "region" {
        default = "us-west-2"
}

provider "aws" {
        region = "${var.region}"
}

resource "aws_instance" "nfconv_worker" {
        count = 30
        ami = "ami-7587a845"
        instance_type = "c4.xlarge"

        key_name = "Dev/spencer"
        iam_instance_profile = "NetflowConverter"
        subnet_id = "subnet-faa4239f"

        security_groups = ["${aws_security_group.nfconv-management.id}"]

        tags = {
                Org = "ids"
                Project = "ids-netflows"
                Repo = "git-aws.internal.justin.tv/ids/nfconvert"
                Name = "nfconvert big worker ${count.index}"
        }

}


resource "aws_security_group" "nfconv-management" {
        name = "nfconv-management"
        description = "only allow access to port 22 from the rest of twitch"
        vpc_id = "vpc-0213b167"
        ingress {
                from_port = 22
                to_port = 22
                protocol = "tcp"
                cidr_blocks = [
                        "10.0.0.0/8",
                        "192.16.64.0/21",
                        "199.9.248.0/21",
                        "185.42.204.0/22",
                        "33.99.10.96/29",
                        "127.0.0.1/32",
                        "38.99.10.97/32",
                ]
        }

        tags = {
                Org = "ids"
                Project = "ids-netflows"
                Repo = "git-aws.internal.justin.tv/ids/nfconvert"
        }

}

output "ips" {
        value = "${join("\n", aws_instance.nfconv_worker.*.private_ip)}"        
}
