variable "config" {
        default = {
                instance_type = "c4.xlarge"
                keypair_name = "Dev/spencer"
                sshkey = "~/.ssh/aws/Devspencer.pem"
                query_ami = "ami-f3567cc3"
                collector_ami = "ami-bd567c8d"

                zone = "us-west-2a"
                vpc = "vpc-0713b162"
                subnet = "subnet-f2a42397"
                num_nodes = 3
        }
}

provider "aws" {
        region = "us-west-2"
}

resource "aws_instance" "collector-node" {
        count = 1
        ami = "${var.config.collector_ami}"
        instance_type = "m3.large"
        availability_zone = "us-west-2a"

        subnet_id = "${var.config.subnet}"
        key_name = "${var.config.keypair_name}"

        security_groups = [
                "${aws_security_group.base.id}",
                "${aws_security_group.nfquery-results.id}",
        ]

        tags {
                Name = "nfquery-collector-${count.index}"
        }

        connection {
                type = "ssh"
                user = "ubuntu"
                host = "${self.private_ip}"
                key_file = "${var.config.sshkey}"
                timeout = "90s"
        }

        provisioner "remote-exec" {
                inline = [
                        "sudo mkdir -p /mnt/nfquery/results",
                        "sudo chown -R ubuntu /mnt/nfquery"
                ]
        }
}

resource "aws_instance" "query-node" {
        count = "${var.config.num_nodes}"
        ami = "${var.config.query_ami}"
        instance_type = "${var.config.instance_type}"
        iam_instance_profile = "NetflowQueryWorker"
        availability_zone = "us-west-2a"

        subnet_id = "${var.config.subnet}"
        key_name = "${var.config.keypair_name}"

        security_groups = [
                "${aws_security_group.base.id}",
                "${aws_security_group.nfquery-results.id}",
        ]

        tags {
                Name = "nfquery-node-${count.index}"
        }

        connection {
                type = "ssh"
                user = "ubuntu"
                host = "${self.private_ip}"
                key_file = "${var.config.sshkey}"
                timeout = "90s"
        }

        user_data = "${aws_instance.collector-node.private_ip}"
}

resource "aws_security_group" "base" {
        name = "nfquery-ssh-access"
        description = "allow SSH access"
        vpc_id = "${var.config.vpc}"
        ingress {
                from_port = 22
                to_port = 22
                protocol = "tcp"
                cidr_blocks = [
                        "10.0.0.0/8",
                        "192.16.64.0/21",
                        "199.9.248.0/21",
                        "185.42.204.0/22"
                ]
        }
}



resource "aws_security_group" "nfquery-results" {
        name = "nfquery-result-messaging"
        description = "allow workers to send results to collector"
        vpc_id = "${var.config.vpc}"
        ingress {
                from_port = 23456
                to_port = 23456
                protocol = "tcp"
                security_groups = ["${aws_security_group.base.id}"]
        }
}
