package parse

import (
	"encoding/binary"
	"io"
)

// Parse counter data.
// Reference C implementation:
//
//	if ( (input_record->flags & FLAG_PKG_64 ) != 0 ) {
//		// 64bit packet counter
//		value64_t	l, *v = (value64_t *)p;
//		l.val.val32[0] = v->val.val32[0];
//		l.val.val32[1] = v->val.val32[1];
//		output_record->dPkts = l.val.val64;
//		p = (void *)((pointer_addr_t)p + sizeof(uint64_t));
//	} else {
//		// 32bit packet counter
//		output_record->dPkts = *((uint32_t *)p);
//		p = (void *)((pointer_addr_t)p + sizeof(uint32_t));
//	}
//
//

func ReadCounter(r io.Reader, sixtyfourbit bool) (uint64, error) {
	if sixtyfourbit {
		return read64bitCount(r)
	} else {
		val, err := read32bitCount(r)
		return uint64(val), err
	}
}

func read64bitCount(r io.Reader) (uint64, error) {
	var pc uint64
	if err := binary.Read(r, binary.LittleEndian, &pc); err != nil {
		return 0, err
	}
	return pc, nil

}

func read32bitCount(r io.Reader) (uint32, error) {
	var pc uint32
	if err := binary.Read(r, binary.LittleEndian, &pc); err != nil {
		return 0, err
	}
	return pc, nil

}
