package parse

// Within each file, there's a list of datablocks. Each DataBlock has
// a header, which specifies its size, type, and number of records.

/* Data Blocks

 * Each data block starts with a common data block header, which
 * specifies the size, type and the number of records in this data
 * block
 *
 */

func (dbh *DataBlockHeader) Compressed() bool {
	return dbh.Flags&DataBlockFlagCompressed != 0
}

type DataBlockHeader struct {
	NumRecords uint32
	Size       uint32
	ID         uint16 // This should map to a type ID
	Flags      uint16
}

const (
	DataBlockType1       = 1
	DataBlockType2       = 2
	LargeRecordBlockType = 3

	DataBlockFlagUncompressed = 1
	DataBlockFlagCompressed   = 2
)

/*
 *
 * Block type 3
 * ============
 * same block header as type 2. Used for data other than flow data - e.g. histograms. Important difference:
 * included data records have type L_record_header_t headers in order to allow larger data records.
 *
 */

type LargeRecordHeader struct {
	Type uint32
	Size uint32
}
