// Code generated by protoc-gen-go.
// source: flowrecord.proto
// DO NOT EDIT!

/*
Package pbflow is a generated protocol buffer package.

It is generated from these files:
	flowrecord.proto

It has these top-level messages:
	FlowRecord
	IPAddress
	MACAddress
*/
package pbflow

import proto "github.com/golang/protobuf/proto"
import math "math"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = math.Inf

// follows IANA protocol numbers, from net/internal/iana/const.go
type Protocol int32

const (
	Protocol_IP              Protocol = 0
	Protocol_ICMP            Protocol = 1
	Protocol_IGMP            Protocol = 2
	Protocol_GGP             Protocol = 3
	Protocol_IPv4            Protocol = 4
	Protocol_ST              Protocol = 5
	Protocol_TCP             Protocol = 6
	Protocol_CBT             Protocol = 7
	Protocol_EGP             Protocol = 8
	Protocol_IGP             Protocol = 9
	Protocol_BBNRCCMON       Protocol = 10
	Protocol_NVPII           Protocol = 11
	Protocol_PUP             Protocol = 12
	Protocol_ARGUS           Protocol = 13
	Protocol_EMCON           Protocol = 14
	Protocol_XNET            Protocol = 15
	Protocol_CHAOS           Protocol = 16
	Protocol_UDP             Protocol = 17
	Protocol_MUX             Protocol = 18
	Protocol_DCNMEAS         Protocol = 19
	Protocol_HMP             Protocol = 20
	Protocol_PRM             Protocol = 21
	Protocol_XNSIDP          Protocol = 22
	Protocol_TRUNK1          Protocol = 23
	Protocol_TRUNK2          Protocol = 24
	Protocol_LEAF1           Protocol = 25
	Protocol_LEAF2           Protocol = 26
	Protocol_RDP             Protocol = 27
	Protocol_IRTP            Protocol = 28
	Protocol_ISOTP4          Protocol = 29
	Protocol_NETBLT          Protocol = 30
	Protocol_MFENSP          Protocol = 31
	Protocol_MERITINP        Protocol = 32
	Protocol_DCCP            Protocol = 33
	Protocol_TPC             Protocol = 34
	Protocol_IDPR            Protocol = 35
	Protocol_XTP             Protocol = 36
	Protocol_DDP             Protocol = 37
	Protocol_IDPRCMTP        Protocol = 38
	Protocol_TPPP            Protocol = 39
	Protocol_IL              Protocol = 40
	Protocol_IPV6            Protocol = 41
	Protocol_SDRP            Protocol = 42
	Protocol_IPV6ROUTE       Protocol = 43
	Protocol_IPV6FRAG        Protocol = 44
	Protocol_IDRP            Protocol = 45
	Protocol_RSVP            Protocol = 46
	Protocol_GRE             Protocol = 47
	Protocol_DSR             Protocol = 48
	Protocol_BNA             Protocol = 49
	Protocol_ESP             Protocol = 50
	Protocol_AH              Protocol = 51
	Protocol_INLSP           Protocol = 52
	Protocol_NARP            Protocol = 54
	Protocol_MOBILE          Protocol = 55
	Protocol_TLSP            Protocol = 56
	Protocol_SKIP            Protocol = 57
	Protocol_IPV6ICMP        Protocol = 58
	Protocol_IPV6NONXT       Protocol = 59
	Protocol_IPV6OPTS        Protocol = 60
	Protocol_CFTP            Protocol = 62
	Protocol_SATEXPAK        Protocol = 64
	Protocol_KRYPTOLAN       Protocol = 65
	Protocol_RVD             Protocol = 66
	Protocol_IPPC            Protocol = 67
	Protocol_SATMON          Protocol = 69
	Protocol_VISA            Protocol = 70
	Protocol_IPCV            Protocol = 71
	Protocol_CPNX            Protocol = 72
	Protocol_CPHB            Protocol = 73
	Protocol_WSN             Protocol = 74
	Protocol_PVP             Protocol = 75
	Protocol_BRSATMON        Protocol = 76
	Protocol_SUNND           Protocol = 77
	Protocol_WBMON           Protocol = 78
	Protocol_WBEXPAK         Protocol = 79
	Protocol_ISOIP           Protocol = 80
	Protocol_VMTP            Protocol = 81
	Protocol_SECUREVMTP      Protocol = 82
	Protocol_VINES           Protocol = 83
	Protocol_IPTM            Protocol = 84
	Protocol_NSFNETIGP       Protocol = 85
	Protocol_DGP             Protocol = 86
	Protocol_TCF             Protocol = 87
	Protocol_EIGRP           Protocol = 88
	Protocol_OSPFIGP         Protocol = 89
	Protocol_SpriteRPC       Protocol = 90
	Protocol_LARP            Protocol = 91
	Protocol_MTP             Protocol = 92
	Protocol_AX25            Protocol = 93
	Protocol_IPIP            Protocol = 94
	Protocol_SCCSP           Protocol = 96
	Protocol_ETHERIP         Protocol = 97
	Protocol_ENCAP           Protocol = 98
	Protocol_GMTP            Protocol = 100
	Protocol_IFMP            Protocol = 101
	Protocol_PNNI            Protocol = 102
	Protocol_PIM             Protocol = 103
	Protocol_ARIS            Protocol = 104
	Protocol_SCPS            Protocol = 105
	Protocol_QNX             Protocol = 106
	Protocol_AN              Protocol = 107
	Protocol_IPCOMP          Protocol = 108
	Protocol_SNP             Protocol = 109
	Protocol_COMPAQ_PEER     Protocol = 110
	Protocol_IPXinIP         Protocol = 111
	Protocol_VRRP            Protocol = 112
	Protocol_PGM             Protocol = 113
	Protocol_L2TP            Protocol = 115
	Protocol_DDX             Protocol = 116
	Protocol_IATP            Protocol = 117
	Protocol_STP             Protocol = 118
	Protocol_SRP             Protocol = 119
	Protocol_UTI             Protocol = 120
	Protocol_SMP             Protocol = 121
	Protocol_SM              Protocol = 122
	Protocol_PTP             Protocol = 123
	Protocol_ISIS            Protocol = 124
	Protocol_FIRE            Protocol = 125
	Protocol_CRTP            Protocol = 126
	Protocol_CRUDP           Protocol = 127
	Protocol_SSCOPMCE        Protocol = 128
	Protocol_IPLT            Protocol = 129
	Protocol_SPS             Protocol = 130
	Protocol_PIPE            Protocol = 131
	Protocol_SCTP            Protocol = 132
	Protocol_FC              Protocol = 133
	Protocol_RSVPE2EIGNORE   Protocol = 134
	Protocol_MOBILITY_HEADER Protocol = 135
	Protocol_UDPLITE         Protocol = 136
	Protocol_MPLS_IN_IP      Protocol = 137
	Protocol_MANET           Protocol = 138
	Protocol_HIP             Protocol = 139
	Protocol_SHIM6           Protocol = 140
	Protocol_WESP            Protocol = 141
	Protocol_ROHC            Protocol = 142
	Protocol_RESERVED        Protocol = 255
)

var Protocol_name = map[int32]string{
	0:   "IP",
	1:   "ICMP",
	2:   "IGMP",
	3:   "GGP",
	4:   "IPv4",
	5:   "ST",
	6:   "TCP",
	7:   "CBT",
	8:   "EGP",
	9:   "IGP",
	10:  "BBNRCCMON",
	11:  "NVPII",
	12:  "PUP",
	13:  "ARGUS",
	14:  "EMCON",
	15:  "XNET",
	16:  "CHAOS",
	17:  "UDP",
	18:  "MUX",
	19:  "DCNMEAS",
	20:  "HMP",
	21:  "PRM",
	22:  "XNSIDP",
	23:  "TRUNK1",
	24:  "TRUNK2",
	25:  "LEAF1",
	26:  "LEAF2",
	27:  "RDP",
	28:  "IRTP",
	29:  "ISOTP4",
	30:  "NETBLT",
	31:  "MFENSP",
	32:  "MERITINP",
	33:  "DCCP",
	34:  "TPC",
	35:  "IDPR",
	36:  "XTP",
	37:  "DDP",
	38:  "IDPRCMTP",
	39:  "TPPP",
	40:  "IL",
	41:  "IPV6",
	42:  "SDRP",
	43:  "IPV6ROUTE",
	44:  "IPV6FRAG",
	45:  "IDRP",
	46:  "RSVP",
	47:  "GRE",
	48:  "DSR",
	49:  "BNA",
	50:  "ESP",
	51:  "AH",
	52:  "INLSP",
	54:  "NARP",
	55:  "MOBILE",
	56:  "TLSP",
	57:  "SKIP",
	58:  "IPV6ICMP",
	59:  "IPV6NONXT",
	60:  "IPV6OPTS",
	62:  "CFTP",
	64:  "SATEXPAK",
	65:  "KRYPTOLAN",
	66:  "RVD",
	67:  "IPPC",
	69:  "SATMON",
	70:  "VISA",
	71:  "IPCV",
	72:  "CPNX",
	73:  "CPHB",
	74:  "WSN",
	75:  "PVP",
	76:  "BRSATMON",
	77:  "SUNND",
	78:  "WBMON",
	79:  "WBEXPAK",
	80:  "ISOIP",
	81:  "VMTP",
	82:  "SECUREVMTP",
	83:  "VINES",
	84:  "IPTM",
	85:  "NSFNETIGP",
	86:  "DGP",
	87:  "TCF",
	88:  "EIGRP",
	89:  "OSPFIGP",
	90:  "SpriteRPC",
	91:  "LARP",
	92:  "MTP",
	93:  "AX25",
	94:  "IPIP",
	96:  "SCCSP",
	97:  "ETHERIP",
	98:  "ENCAP",
	100: "GMTP",
	101: "IFMP",
	102: "PNNI",
	103: "PIM",
	104: "ARIS",
	105: "SCPS",
	106: "QNX",
	107: "AN",
	108: "IPCOMP",
	109: "SNP",
	110: "COMPAQ_PEER",
	111: "IPXinIP",
	112: "VRRP",
	113: "PGM",
	115: "L2TP",
	116: "DDX",
	117: "IATP",
	118: "STP",
	119: "SRP",
	120: "UTI",
	121: "SMP",
	122: "SM",
	123: "PTP",
	124: "ISIS",
	125: "FIRE",
	126: "CRTP",
	127: "CRUDP",
	128: "SSCOPMCE",
	129: "IPLT",
	130: "SPS",
	131: "PIPE",
	132: "SCTP",
	133: "FC",
	134: "RSVPE2EIGNORE",
	135: "MOBILITY_HEADER",
	136: "UDPLITE",
	137: "MPLS_IN_IP",
	138: "MANET",
	139: "HIP",
	140: "SHIM6",
	141: "WESP",
	142: "ROHC",
	255: "RESERVED",
}
var Protocol_value = map[string]int32{
	"IP":              0,
	"ICMP":            1,
	"IGMP":            2,
	"GGP":             3,
	"IPv4":            4,
	"ST":              5,
	"TCP":             6,
	"CBT":             7,
	"EGP":             8,
	"IGP":             9,
	"BBNRCCMON":       10,
	"NVPII":           11,
	"PUP":             12,
	"ARGUS":           13,
	"EMCON":           14,
	"XNET":            15,
	"CHAOS":           16,
	"UDP":             17,
	"MUX":             18,
	"DCNMEAS":         19,
	"HMP":             20,
	"PRM":             21,
	"XNSIDP":          22,
	"TRUNK1":          23,
	"TRUNK2":          24,
	"LEAF1":           25,
	"LEAF2":           26,
	"RDP":             27,
	"IRTP":            28,
	"ISOTP4":          29,
	"NETBLT":          30,
	"MFENSP":          31,
	"MERITINP":        32,
	"DCCP":            33,
	"TPC":             34,
	"IDPR":            35,
	"XTP":             36,
	"DDP":             37,
	"IDPRCMTP":        38,
	"TPPP":            39,
	"IL":              40,
	"IPV6":            41,
	"SDRP":            42,
	"IPV6ROUTE":       43,
	"IPV6FRAG":        44,
	"IDRP":            45,
	"RSVP":            46,
	"GRE":             47,
	"DSR":             48,
	"BNA":             49,
	"ESP":             50,
	"AH":              51,
	"INLSP":           52,
	"NARP":            54,
	"MOBILE":          55,
	"TLSP":            56,
	"SKIP":            57,
	"IPV6ICMP":        58,
	"IPV6NONXT":       59,
	"IPV6OPTS":        60,
	"CFTP":            62,
	"SATEXPAK":        64,
	"KRYPTOLAN":       65,
	"RVD":             66,
	"IPPC":            67,
	"SATMON":          69,
	"VISA":            70,
	"IPCV":            71,
	"CPNX":            72,
	"CPHB":            73,
	"WSN":             74,
	"PVP":             75,
	"BRSATMON":        76,
	"SUNND":           77,
	"WBMON":           78,
	"WBEXPAK":         79,
	"ISOIP":           80,
	"VMTP":            81,
	"SECUREVMTP":      82,
	"VINES":           83,
	"IPTM":            84,
	"NSFNETIGP":       85,
	"DGP":             86,
	"TCF":             87,
	"EIGRP":           88,
	"OSPFIGP":         89,
	"SpriteRPC":       90,
	"LARP":            91,
	"MTP":             92,
	"AX25":            93,
	"IPIP":            94,
	"SCCSP":           96,
	"ETHERIP":         97,
	"ENCAP":           98,
	"GMTP":            100,
	"IFMP":            101,
	"PNNI":            102,
	"PIM":             103,
	"ARIS":            104,
	"SCPS":            105,
	"QNX":             106,
	"AN":              107,
	"IPCOMP":          108,
	"SNP":             109,
	"COMPAQ_PEER":     110,
	"IPXinIP":         111,
	"VRRP":            112,
	"PGM":             113,
	"L2TP":            115,
	"DDX":             116,
	"IATP":            117,
	"STP":             118,
	"SRP":             119,
	"UTI":             120,
	"SMP":             121,
	"SM":              122,
	"PTP":             123,
	"ISIS":            124,
	"FIRE":            125,
	"CRTP":            126,
	"CRUDP":           127,
	"SSCOPMCE":        128,
	"IPLT":            129,
	"SPS":             130,
	"PIPE":            131,
	"SCTP":            132,
	"FC":              133,
	"RSVPE2EIGNORE":   134,
	"MOBILITY_HEADER": 135,
	"UDPLITE":         136,
	"MPLS_IN_IP":      137,
	"MANET":           138,
	"HIP":             139,
	"SHIM6":           140,
	"WESP":            141,
	"ROHC":            142,
	"RESERVED":        255,
}

func (x Protocol) Enum() *Protocol {
	p := new(Protocol)
	*p = x
	return p
}
func (x Protocol) String() string {
	return proto.EnumName(Protocol_name, int32(x))
}
func (x *Protocol) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Protocol_value, data, "Protocol")
	if err != nil {
		return err
	}
	*x = Protocol(value)
	return nil
}

// Differentiated Services Field Codepoints (DSCP), from net/internal/iana/const.go
type DSCP int32

const (
	DSCP_CS0        DSCP = 0
	DSCP_CS1        DSCP = 32
	DSCP_CS2        DSCP = 64
	DSCP_CS3        DSCP = 96
	DSCP_CS4        DSCP = 128
	DSCP_CS5        DSCP = 160
	DSCP_CS6        DSCP = 192
	DSCP_CS7        DSCP = 224
	DSCP_AF11       DSCP = 40
	DSCP_AF12       DSCP = 48
	DSCP_AF13       DSCP = 56
	DSCP_AF21       DSCP = 72
	DSCP_AF22       DSCP = 80
	DSCP_AF23       DSCP = 88
	DSCP_AF31       DSCP = 104
	DSCP_AF32       DSCP = 112
	DSCP_AF33       DSCP = 120
	DSCP_AF41       DSCP = 136
	DSCP_AF42       DSCP = 144
	DSCP_AF43       DSCP = 152
	DSCP_EFPHB      DSCP = 184
	DSCP_VOICEADMIT DSCP = 176
)

var DSCP_name = map[int32]string{
	0:   "CS0",
	32:  "CS1",
	64:  "CS2",
	96:  "CS3",
	128: "CS4",
	160: "CS5",
	192: "CS6",
	224: "CS7",
	40:  "AF11",
	48:  "AF12",
	56:  "AF13",
	72:  "AF21",
	80:  "AF22",
	88:  "AF23",
	104: "AF31",
	112: "AF32",
	120: "AF33",
	136: "AF41",
	144: "AF42",
	152: "AF43",
	184: "EFPHB",
	176: "VOICEADMIT",
}
var DSCP_value = map[string]int32{
	"CS0":        0,
	"CS1":        32,
	"CS2":        64,
	"CS3":        96,
	"CS4":        128,
	"CS5":        160,
	"CS6":        192,
	"CS7":        224,
	"AF11":       40,
	"AF12":       48,
	"AF13":       56,
	"AF21":       72,
	"AF22":       80,
	"AF23":       88,
	"AF31":       104,
	"AF32":       112,
	"AF33":       120,
	"AF41":       136,
	"AF42":       144,
	"AF43":       152,
	"EFPHB":      184,
	"VOICEADMIT": 176,
}

func (x DSCP) Enum() *DSCP {
	p := new(DSCP)
	*p = x
	return p
}
func (x DSCP) String() string {
	return proto.EnumName(DSCP_name, int32(x))
}
func (x *DSCP) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(DSCP_value, data, "DSCP")
	if err != nil {
		return err
	}
	*x = DSCP(value)
	return nil
}

// follows IANA Type of Service byte definitions for bits 6-7, net/internal/iana/const.go
type ECN int32

const (
	ECN_NOT_ECN_TRANSPORT      ECN = 0
	ECN_ECN_TRANSPORT_1        ECN = 1
	ECN_ECN_TRANSPORT_0        ECN = 2
	ECN_CONGESTION_EXPERIENCED ECN = 3
)

var ECN_name = map[int32]string{
	0: "NOT_ECN_TRANSPORT",
	1: "ECN_TRANSPORT_1",
	2: "ECN_TRANSPORT_0",
	3: "CONGESTION_EXPERIENCED",
}
var ECN_value = map[string]int32{
	"NOT_ECN_TRANSPORT":      0,
	"ECN_TRANSPORT_1":        1,
	"ECN_TRANSPORT_0":        2,
	"CONGESTION_EXPERIENCED": 3,
}

func (x ECN) Enum() *ECN {
	p := new(ECN)
	*p = x
	return p
}
func (x ECN) String() string {
	return proto.EnumName(ECN_name, int32(x))
}
func (x *ECN) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(ECN_value, data, "ECN")
	if err != nil {
		return err
	}
	*x = ECN(value)
	return nil
}

// Flow direction: 0 - ingress flow, 1 - egress flow
type FlowRecord_Direction int32

const (
	FlowRecord_INGRESS FlowRecord_Direction = 0
	FlowRecord_EGRESS  FlowRecord_Direction = 1
)

var FlowRecord_Direction_name = map[int32]string{
	0: "INGRESS",
	1: "EGRESS",
}
var FlowRecord_Direction_value = map[string]int32{
	"INGRESS": 0,
	"EGRESS":  1,
}

func (x FlowRecord_Direction) Enum() *FlowRecord_Direction {
	p := new(FlowRecord_Direction)
	*p = x
	return p
}
func (x FlowRecord_Direction) String() string {
	return proto.EnumName(FlowRecord_Direction_name, int32(x))
}
func (x *FlowRecord_Direction) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(FlowRecord_Direction_value, data, "FlowRecord_Direction")
	if err != nil {
		return err
	}
	*x = FlowRecord_Direction(value)
	return nil
}

type IPAddress_Version int32

const (
	IPAddress_IPV4 IPAddress_Version = 0
	IPAddress_IPV6 IPAddress_Version = 1
)

var IPAddress_Version_name = map[int32]string{
	0: "IPV4",
	1: "IPV6",
}
var IPAddress_Version_value = map[string]int32{
	"IPV4": 0,
	"IPV6": 1,
}

func (x IPAddress_Version) Enum() *IPAddress_Version {
	p := new(IPAddress_Version)
	*p = x
	return p
}
func (x IPAddress_Version) String() string {
	return proto.EnumName(IPAddress_Version_name, int32(x))
}
func (x *IPAddress_Version) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(IPAddress_Version_value, data, "IPAddress_Version")
	if err != nil {
		return err
	}
	*x = IPAddress_Version(value)
	return nil
}

type FlowRecord struct {
	// Addressing
	// IP source/dest address
	SrcIp *IPAddress `protobuf:"bytes,1,req,name=src_ip" json:"src_ip,omitempty"`
	DstIp *IPAddress `protobuf:"bytes,2,req,name=dst_ip" json:"dst_ip,omitempty"`
	// TCP/UDP src/dest port number
	SrcPort *uint32 `protobuf:"varint,3,opt,name=src_port" json:"src_port,omitempty"`
	DstPort *uint32 `protobuf:"varint,4,opt,name=dst_port" json:"dst_port,omitempty"`
	// The IP protocol byte
	Protocol *Protocol `protobuf:"varint,5,req,name=protocol,enum=code.justin.tv.ids.flowrecord.Protocol" json:"protocol,omitempty"`
	// Time of first and last packet switched in Unix epoch nanoseconds
	FlowStart *uint64 `protobuf:"varint,6,req,name=flow_start" json:"flow_start,omitempty"`
	FlowEnd   *uint64 `protobuf:"varint,7,req,name=flow_end" json:"flow_end,omitempty"`
	// Counters
	// Incoming counter for number of packets associated with an IP Flow.
	PacketsIn *uint64 `protobuf:"varint,8,req,name=packets_in" json:"packets_in,omitempty"`
	// Incoming counter for number of bytes associated with an IP Flow.
	BytesIn *uint64 `protobuf:"varint,9,req,name=bytes_in" json:"bytes_in,omitempty"`
	// The number of contiguous bits in the source/dest address subnet
	// mask i.e. the submask in slash notation
	SrcMask *uint32 `protobuf:"varint,10,opt,name=src_mask" json:"src_mask,omitempty"`
	DstMask *uint32 `protobuf:"varint,11,opt,name=dst_mask" json:"dst_mask,omitempty"`
	// Incoming/outgoing source/dest MAC address
	InSrcMac  *MACAddress `protobuf:"bytes,12,opt,name=in_src_mac" json:"in_src_mac,omitempty"`
	InDstMac  *MACAddress `protobuf:"bytes,13,opt,name=in_dst_mac" json:"in_dst_mac,omitempty"`
	OutSrcMac *MACAddress `protobuf:"bytes,14,opt,name=out_src_mac" json:"out_src_mac,omitempty"`
	OutDstMac *MACAddress `protobuf:"bytes,15,opt,name=out_dst_mac" json:"out_dst_mac,omitempty"`
	// Source/dest BGP autonomous system number
	SrcAs *uint32 `protobuf:"varint,16,opt,name=src_as" json:"src_as,omitempty"`
	DstAs *uint32 `protobuf:"varint,17,opt,name=dst_as" json:"dst_as,omitempty"`
	// IP Address of the next-hop router
	NextHop *IPAddress `protobuf:"bytes,18,opt,name=next_hop" json:"next_hop,omitempty"`
	// Next-hop router's IP in the BGP domain
	NextHopBgp *IPAddress `protobuf:"bytes,19,opt,name=next_hop_bgp" json:"next_hop_bgp,omitempty"`
	// Number of flows that were aggregated
	AggrFlows *uint64 `protobuf:"varint,20,opt,name=aggr_flows" json:"aggr_flows,omitempty"`
	// Protocol Info
	// Type of Service byte setting when entering incoming interface
	InTosByte *uint32 `protobuf:"varint,21,opt,name=in_tos_byte" json:"in_tos_byte,omitempty"`
	// Type of Service byte setting when exiting outgoing interface
	OutTosByte *uint32 `protobuf:"varint,22,opt,name=out_tos_byte" json:"out_tos_byte,omitempty"`
	// Cumulative of all the TCP flags seen for this flow
	TcpFlags  *uint32               `protobuf:"varint,23,opt,name=tcp_flags" json:"tcp_flags,omitempty"`
	Direction *FlowRecord_Direction `protobuf:"varint,24,opt,name=direction,enum=code.justin.tv.ids.flowrecord.FlowRecord_Direction" json:"direction,omitempty"`
	// SNMP
	// Input interface index
	InputSnmp *uint64 `protobuf:"varint,25,opt,name=input_snmp" json:"input_snmp,omitempty"`
	// Output interface index
	OutputSnmp *uint64 `protobuf:"varint,26,opt,name=output_snmp" json:"output_snmp,omitempty"`
	// VLAN
	// Virtual LAN identifier associated with ingress interface
	SrcVlan *uint32 `protobuf:"varint,27,opt,name=src_vlan" json:"src_vlan,omitempty"`
	// Virtual LAN identifier associated with egress interface
	DstVlan          *uint32 `protobuf:"varint,28,opt,name=dst_vlan" json:"dst_vlan,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *FlowRecord) Reset()         { *m = FlowRecord{} }
func (m *FlowRecord) String() string { return proto.CompactTextString(m) }
func (*FlowRecord) ProtoMessage()    {}

func (m *FlowRecord) GetSrcIp() *IPAddress {
	if m != nil {
		return m.SrcIp
	}
	return nil
}

func (m *FlowRecord) GetDstIp() *IPAddress {
	if m != nil {
		return m.DstIp
	}
	return nil
}

func (m *FlowRecord) GetSrcPort() uint32 {
	if m != nil && m.SrcPort != nil {
		return *m.SrcPort
	}
	return 0
}

func (m *FlowRecord) GetDstPort() uint32 {
	if m != nil && m.DstPort != nil {
		return *m.DstPort
	}
	return 0
}

func (m *FlowRecord) GetProtocol() Protocol {
	if m != nil && m.Protocol != nil {
		return *m.Protocol
	}
	return Protocol_IP
}

func (m *FlowRecord) GetFlowStart() uint64 {
	if m != nil && m.FlowStart != nil {
		return *m.FlowStart
	}
	return 0
}

func (m *FlowRecord) GetFlowEnd() uint64 {
	if m != nil && m.FlowEnd != nil {
		return *m.FlowEnd
	}
	return 0
}

func (m *FlowRecord) GetPacketsIn() uint64 {
	if m != nil && m.PacketsIn != nil {
		return *m.PacketsIn
	}
	return 0
}

func (m *FlowRecord) GetBytesIn() uint64 {
	if m != nil && m.BytesIn != nil {
		return *m.BytesIn
	}
	return 0
}

func (m *FlowRecord) GetSrcMask() uint32 {
	if m != nil && m.SrcMask != nil {
		return *m.SrcMask
	}
	return 0
}

func (m *FlowRecord) GetDstMask() uint32 {
	if m != nil && m.DstMask != nil {
		return *m.DstMask
	}
	return 0
}

func (m *FlowRecord) GetInSrcMac() *MACAddress {
	if m != nil {
		return m.InSrcMac
	}
	return nil
}

func (m *FlowRecord) GetInDstMac() *MACAddress {
	if m != nil {
		return m.InDstMac
	}
	return nil
}

func (m *FlowRecord) GetOutSrcMac() *MACAddress {
	if m != nil {
		return m.OutSrcMac
	}
	return nil
}

func (m *FlowRecord) GetOutDstMac() *MACAddress {
	if m != nil {
		return m.OutDstMac
	}
	return nil
}

func (m *FlowRecord) GetSrcAs() uint32 {
	if m != nil && m.SrcAs != nil {
		return *m.SrcAs
	}
	return 0
}

func (m *FlowRecord) GetDstAs() uint32 {
	if m != nil && m.DstAs != nil {
		return *m.DstAs
	}
	return 0
}

func (m *FlowRecord) GetNextHop() *IPAddress {
	if m != nil {
		return m.NextHop
	}
	return nil
}

func (m *FlowRecord) GetNextHopBgp() *IPAddress {
	if m != nil {
		return m.NextHopBgp
	}
	return nil
}

func (m *FlowRecord) GetAggrFlows() uint64 {
	if m != nil && m.AggrFlows != nil {
		return *m.AggrFlows
	}
	return 0
}

func (m *FlowRecord) GetInTosByte() uint32 {
	if m != nil && m.InTosByte != nil {
		return *m.InTosByte
	}
	return 0
}

func (m *FlowRecord) GetOutTosByte() uint32 {
	if m != nil && m.OutTosByte != nil {
		return *m.OutTosByte
	}
	return 0
}

func (m *FlowRecord) GetTcpFlags() uint32 {
	if m != nil && m.TcpFlags != nil {
		return *m.TcpFlags
	}
	return 0
}

func (m *FlowRecord) GetDirection() FlowRecord_Direction {
	if m != nil && m.Direction != nil {
		return *m.Direction
	}
	return FlowRecord_INGRESS
}

func (m *FlowRecord) GetInputSnmp() uint64 {
	if m != nil && m.InputSnmp != nil {
		return *m.InputSnmp
	}
	return 0
}

func (m *FlowRecord) GetOutputSnmp() uint64 {
	if m != nil && m.OutputSnmp != nil {
		return *m.OutputSnmp
	}
	return 0
}

func (m *FlowRecord) GetSrcVlan() uint32 {
	if m != nil && m.SrcVlan != nil {
		return *m.SrcVlan
	}
	return 0
}

func (m *FlowRecord) GetDstVlan() uint32 {
	if m != nil && m.DstVlan != nil {
		return *m.DstVlan
	}
	return 0
}

// Can be IPv4 or IPv6
type IPAddress struct {
	Data             []uint32           `protobuf:"varint,1,rep,packed,name=data" json:"data,omitempty"`
	Version          *IPAddress_Version `protobuf:"varint,2,req,name=version,enum=code.justin.tv.ids.flowrecord.IPAddress_Version" json:"version,omitempty"`
	XXX_unrecognized []byte             `json:"-"`
}

func (m *IPAddress) Reset()         { *m = IPAddress{} }
func (m *IPAddress) String() string { return proto.CompactTextString(m) }
func (*IPAddress) ProtoMessage()    {}

func (m *IPAddress) GetData() []uint32 {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *IPAddress) GetVersion() IPAddress_Version {
	if m != nil && m.Version != nil {
		return *m.Version
	}
	return IPAddress_IPV4
}

type MACAddress struct {
	Data             []uint32 `protobuf:"varint,1,rep,packed,name=data" json:"data,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *MACAddress) Reset()         { *m = MACAddress{} }
func (m *MACAddress) String() string { return proto.CompactTextString(m) }
func (*MACAddress) ProtoMessage()    {}

func (m *MACAddress) GetData() []uint32 {
	if m != nil {
		return m.Data
	}
	return nil
}

func init() {
	proto.RegisterEnum("code.justin.tv.ids.flowrecord.Protocol", Protocol_name, Protocol_value)
	proto.RegisterEnum("code.justin.tv.ids.flowrecord.DSCP", DSCP_name, DSCP_value)
	proto.RegisterEnum("code.justin.tv.ids.flowrecord.ECN", ECN_name, ECN_value)
	proto.RegisterEnum("code.justin.tv.ids.flowrecord.FlowRecord_Direction", FlowRecord_Direction_name, FlowRecord_Direction_value)
	proto.RegisterEnum("code.justin.tv.ids.flowrecord.IPAddress_Version", IPAddress_Version_name, IPAddress_Version_value)
}
