package query

import (
	"encoding/json"
	"net"

	"code.justin.tv/ids/nfconvert/parse"
)

type QueryRequest struct {
	S3Key     string `json: s3_key`
	Filter    FilterRPC
	QueryName string
}

type QueryResult struct {
	FlowRecord *parse.Record `json: flow_record`
	QueryName  string
	S3Key      string `json: s3_key`
}

// Send result to collector at given address
func (qr *QueryResult) Send(addr string) error {
	body, err := json.Marshal(qr)
	if err != nil {
		return err
	}

	conn, err := net.Dial("tcp", addr)
	if err != nil {
		return err
	}

	body = []byte(string(body) + "\n")
	_, err = conn.Write(body)
	if err != nil {
		return err
	}
	err = conn.Close()
	if err != nil {
		return err
	}
	return nil
}
