package query

import (
	"github.com/crowdmob/goamz/aws"
	"github.com/crowdmob/goamz/sqs"
	"github.com/twitchscience/aws_utils/listener"
)

func GetTaskQueue(auth aws.Auth) (*sqs.Queue, error) {
	client := sqs.New(auth, aws.Regions[Region])
	return client.GetQueue(TaskQueueName)
}

func GetResultQueue(auth aws.Auth) (*sqs.Queue, error) {
	client := sqs.New(auth, aws.Regions[Region])
	return client.GetQueue(ResultQueueName)
}

func GetTaskQueueAddr(auth aws.Auth) *listener.SQSAddr {
	return &listener.SQSAddr{
		aws.Regions[Region],
		TaskQueueName,
		auth,
	}
}

func GetResultQueueAddr(auth aws.Auth) *listener.SQSAddr {
	return &listener.SQSAddr{
		aws.Regions[Region],
		ResultQueueName,
		auth,
	}
}
