#!/usr/bin/env bash

set -xe -o pipefail

here=$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd ) # directory of script
env="$here/s3env"

function make_virtualenv {
    curl -o /tmp/virtualenv-12.0.7.tar.gz https://pypi.python.org/packages/source/v/virtualenv/virtualenv-12.0.7.tar.gz
    tar -xzvf /tmp/virtualenv-12.0.7.tar.gz -C /tmp
    python /tmp/virtualenv-12.0.7/virtualenv.py $env
    rm -rf /tmp/virtualenv-12.0.7
}

function install_s3cmd_to_venv {
    ln -s ../vendor/s3cmd $env/s3cmd
    cd $env/s3cmd && $env/bin/python setup.py install
}

make_virtualenv
install_s3cmd_to_venv
