# s3sync #

This syncs local directories and S3 buckets. In fact, it can happily
sync two local directories, or two s3 buckets, but there are probably
better tools to do that. The intention is that this be used to mirror
local directories up in S3 and vice-versa.

    USAGE

    s3sync [options] SYNCFROM SYNCTO

    Syncs directory SYNCTO to match contents of SYNCFROM. Both SYNCTO and SYNCFROM
    can be either local paths or remote S3 paths. S3 paths should be specified
    with this syntax:

      s3://<bucket>/<optional path>

    For example,

      s3sync /var/log/ s3://logs/raw/

    would update s3://logs/raw/ to match the contents of /var/log/, including traversing
    subdirectories.

    OPTIONS
      -aws-access-key-id="": access key ID to use when talking to AWS
      -aws-region="us-west-2": region to use when talking to AWS
      -aws-secret-key="": secret key to use when talking to AWS
      -debug=false: be overwhelmingly chatty in logs
      -delete-missing=false: delete files in SYNCTO if they are not present in SYNCFROM
      -follow-symlinks=false: follow symlinks when gathering the set of files in SYNCFROM and SYNCTO
      -quiet=false: suppress all log output
      -skip-checksum=false: skip checking md5sums of files and just use file size instead
      -verbose=false: be chatty in logs

    PERMISSIONS
    If you don't have permission to read a local file, it will be skipped. To see
    when this happens, turn on verbose logging.
