package s3sync

type Directory interface {
	Contents() (map[string]file, error) // maps paths to files
	// Create a new file at path and match contents from an open file. Return error if file exists.
	Create(subpath string, contents file) error
	// Update the file at path to match contents from an open file. Return error if file doesn't exist.
	Update(subpath string, contents file) error
	// Delete file at path. Return error if file doesn't exist.
	Delete(subpath string) error
	// Clean up, removing empty subdirectories
	Clean() error
}
