package s3sync

import (
	"fmt"

	"gopkg.in/amz.v1/aws"
)

var (
	awsAuth   aws.Auth
	awsRegion aws.Region
)

func SetAuth(keyid, secret string) {
	awsAuth = aws.Auth{keyid, secret}
	Log.Debug("using creds: %+v", awsAuth)
}

func SetRegion(region string) error {
	var ok bool
	awsRegion, ok = aws.Regions[region]
	if !ok {
		return fmt.Errorf("Unknown region %s", region)
	}
	return nil
}
