package main

import (
	"log"
	"net"
)

const BufSize = 64 * 1024 // 64kB max packet size

func listenUDP(sAddr string) *net.UDPConn {
	addr, err := net.ResolveUDPAddr("udp", sAddr)
	if err != nil {
		log.Fatalf("failed to resolve address for UDP socket, %v", err)
	}
	conn, err := net.ListenUDP("udp", addr)
	if err != nil {
		log.Fatalf("failed to open UDP socket for listening, %v", err)
	}
	return conn
}
