package main

import (
	"net"

	"code.google.com/p/gopacket/layers"
)

type CapturedPacket struct {
	Protocol        layers.IPProtocol
	SourceIP        net.IP
	SourcePort      uint16
	DestinationIP   net.IP
	DestinationPort uint16
	Length          uint16
}

type CapturedPacketDigest struct {
	Protocol        string `json:"protocol"`
	SFlowHost       string `json:"sflow_host"`
	SourceIP        string `json:"source_ip"`
	SourcePort      uint16 `json:"source_port"`
	DestinationIP   string `json:"dest_ip"`
	DestinationPort uint16 `json:"dest_port"`
	Bytes           uint64 `json:"byte_count"`
	Packets         uint64 `json:"packet_count"`
}
