package main

import (
	"bytes"
	"log"
	"net"
	"sync"
	"sync/atomic"
	"time"
)

func receiveUDPWorker(conn *net.UDPConn, c chan []byte, wg sync.WaitGroup) {
	defer wg.Done()
	for {

		buf := make([]byte, BufSize)
		_, err := conn.Read(buf)
		if err != nil {
			log.Printf("udp connection closed")
			return
		}
		select {
		case c <- buf:
		default:
			atomic.AddUint64(&packetLoss, 1)
		}
	}
}

func packetWorker(in <-chan []byte, out chan<- *CapturedPacket, wg sync.WaitGroup, filter *Filter) {
	defer wg.Done()
	for buf := range in {
		packets := FindPackets(bytes.NewReader(buf), filter)
		for _, p := range packets {
			out <- p
		}
	}
}

func tick(d time.Duration, c chan struct{}) {
	for {
		time.Sleep(d)
		c <- struct{}{}
	}
}
