#####################
# Production Config #
#####################

variable "names" {
	default {
		vpc = "us-west-2-prod"
	}
}

variable "enviroment" {
	default {
		name = "Production"
		identifier = ""
		domain = "prod.us-west2.justin.tv"
	}
}

variable "ids" {
	default {
		# ID for the current vpc:
		vpc = "vpc-0213b167"

		# ids-kibana self signed cert id
		ids-kibana-cert = "arn:aws:iam::673385534282:server-certificate/wildcard.internal.justin.tv"

		# Route53 zones:
		privateR53 = "ZRG00SM48517Z"

		# logstash ami
		base-ami = "ami-bdb6948d"

		# ami that mounts the ebs volumes at boot
		ebsmount-ami = "ami-29e2ce19"

		# ami based off the ubuntu pv ami
		pv-ami = "ami-23ebb513"
	}
}

variable "counts" {
	default {
		ids-logstash-ingest = 12
		ids-elasticsearch-ebsmount = 7
		ids-elasticsearch-instancemount = 0
		ids-kibana = 2
		ids-logstash-syslog = 4
	}
}

variable "avail" {
	default {
		zone0 = "subnet-faa4239f"
		zone1 = "subnet-9c4ab1c5"
		zone2 = "subnet-88a207ff"
		# Hack to support larger server counts:
		zone3  = "subnet-faa4239f"
		zone4  = "subnet-88a207ff"
		zone5  = "subnet-9c4ab1c5"
		zone6  = "subnet-faa4239f"
		zone7  = "subnet-88a207ff"
		zone8  = "subnet-9c4ab1c5"
		zone9  = "subnet-faa4239f"
		zone10 = "subnet-88a207ff"
		zone11 = "subnet-9c4ab1c5"
		zone12 = "subnet-faa4239f"
		zone13 = "subnet-88a207ff"
		zone14 = "subnet-9c4ab1c5"
		zone15 = "subnet-faa4239f"
		zone16 = "subnet-88a207ff"
		zone17 = "subnet-9c4ab1c5"
		zone18 = "subnet-faa4239f"
		zone19 = "subnet-88a207ff"
		zone20 = "subnet-9c4ab1c5"
	}
}


