from __future__ import absolute_import
from ansible import errors

def broker_id_from_ip(value):
    if not isinstance(value, basestring):
        value = str(value)

    value = value.split('.')
    if len(value) != 4:
        raise errors.AnsibleFilterError("|failed expects ipv4 addr")

    try:
        return (int(value[0])<<24)+(int(value[1])<<16)+(int(value[2])<<8)+int(value[3])
    except ValueError:
        raise errors.AnsibleFilterError("|failed expects ipv4 addr")

    return None

class FilterModule(object):
    def filters(self):
        return {
            'broker_id_from_ip': broker_id_from_ip
        }