# Should be moved to a base module
provider "aws" {
	region = "us-west-2"
	access_key = "AKIAIUOP3J3LNZRQZOPA"
    secret_key = "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"
}

#####################
# Production Config #
#####################

variable "names" {
	default {
		vpc = "us-west-2-prod"
	}
}

variable "ids" {
	default {
		# ID for the current vpc:
		vpc = "vpc-0213b167"

		# Route53 zones:
		privateR53 = "ZRG00SM48517Z"

		# logstash ami
		logstash-ami = "ami-89f9d4b9"

		# es ami
		elasticsearch-ami = "ami-4bffd27b"
	}
}

variable "avail" {
	default {
		zone0 = "subnet-faa4239f"
		zone1 = "subnet-88a207ff"
		zone2 = "subnet-9c4ab1c5"
		# Hack to support larger server counts:
		zone3  = "subnet-faa4239f"
		zone4  = "subnet-88a207ff"
		zone5  = "subnet-9c4ab1c5"
		zone6  = "subnet-faa4239f"
		zone7  = "subnet-88a207ff"
		zone8  = "subnet-9c4ab1c5"
		zone9  = "subnet-faa4239f"
		zone10 = "subnet-88a207ff"
		zone11 = "subnet-9c4ab1c5"
		zone12 = "subnet-faa4239f"
		zone13 = "subnet-88a207ff"
		zone14 = "subnet-9c4ab1c5"
		zone15 = "subnet-faa4239f"
		zone16 = "subnet-88a207ff"
		zone17 = "subnet-9c4ab1c5"
		zone18 = "subnet-faa4239f"
		zone19 = "subnet-88a207ff"
		zone20 = "subnet-9c4ab1c5"
	}
}

###################
# Security Groups #
###################

resource "aws_security_group" "ids-elk" {
    name = "ids-elk"
    description = "lock the elk cluster up"
	vpc_id="${var.ids.vpc}"

	ingress {
		from_port = 0
		to_port = 65535
		protocol = "tcp"
		security_groups = ["${aws_security_group.logstash-ingest.id}"]
	}

	ingress {
		from_port = 0
		to_port = 65535
		protocol = "tcp"
		cidr_blocks = ["10.255.252.17/32", "10.255.252.15/32" ,"199.9.253.87/32", "10.0.0.58/32"]
	}

	ingress {
		from_port = 0
		to_port = 65535
		protocol = "tcp"
		self = true
	}

	ingress {
		from_port = 0
		to_port = 65535
		protocol = "udp"
		self = true
	}
}

resource "aws_security_group" "logstash-ingest" {
	name = "logstash-ingest"
	description = "allow internal hosts to push logs"
	vpc_id="${var.ids.vpc}"

	ingress {
		from_port = 0
		to_port = 65535
		protocol = "tcp"
		cidr_blocks = [
		 	"10.0.0.0/8",
			"192.16.64.0/21",
			"199.9.248.0/21",
			"185.42.204.0/22",
			"33.99.10.96/29",
			"127.0.0.1/32",
			"38.99.10.97/32",
		]
    }
}

###################
# logstash ingest #
###################

resource "aws_route53_record" "ids-logstash-ingest" {
   zone_id = "${var.ids.privateR53}"
   name = "ids-logstash-ingest.prod.us-west2.justin.tv"
   type = "CNAME"
   ttl = "300"
   records = ["${aws_elb.logstash-ingest.dns_name}"]
}

resource "aws_elb" "logstash-ingest" {
  name = "logstash-ingest"
  subnets = ["${var.avail.zone0}", "${var.avail.zone1}", "${var.avail.zone2}"]

  security_groups = ["${aws_security_group.logstash-ingest.id}", "${aws_security_group.ids-elk.id}"]
  internal = true

  listener {
    instance_port = 1028
    instance_protocol = "tcp"
    lb_port = 1028
    lb_protocol = "tcp"
  }

  listener {
  	instance_port = 10000
  	instance_protocol = "tcp"
  	lb_port = 10000
  	lb_protocol = "tcp"
  }

  listener {
  	instance_port = 10001
  	instance_protocol = "tcp"
  	lb_port = 10001
  	lb_protocol = "tcp"
  }

  health_check {
    healthy_threshold = 2
    unhealthy_threshold = 2
    timeout = 3
    target = "TCP:1028"
    interval = 30
  }

  instances = ["${aws_instance.logstash-ingest.*.id}"]
  cross_zone_load_balancing = true
}

resource "aws_instance" "logstash-ingest" {
	count = 8
	ami = "${var.ids.logstash-ami}"
	instance_type = "m3.medium"
	subnet_id = "${lookup(var.avail, concat("zone", count.index))}"
	security_groups = ["${aws_security_group.ids-elk.id}"]
	key_name = "ids_management"

	iam_instance_profile = "SplashMountainLogstash"

	tags {
		Name = "logstash-ingest-${count.index}.prod.us-west2.justin.tv"
	}

	user_data = <<USER_DATA
export GRAPHITE_PREFIX=logstash-ingest.prod.us-west-2.no_asg
export S3_STORAGE_BUCKET=lumberjack-forest
export ES_HOST=${element(aws_instance.logstash-es.*.private_ip, count.index)}
USER_DATA
}

#################
# elasticsearch #
#################

resource "aws_route53_record" "ids-logstash-es-head" {
   zone_id = "${var.ids.privateR53}"
   name = "ids-logstash-es-head.prod.us-west2.justin.tv"
   type = "A"
   ttl = "300"
   records = ["${aws_instance.logstash-es-head.private_ip}"]
}

resource "aws_instance" "logstash-es-head" {
	count = 1
	ami = "${var.ids.elasticsearch-ami}"
	instance_type = "m3.xlarge"
	subnet_id = "${var.avail.zone0}"
	security_groups = ["${aws_security_group.ids-elk.id}"]
	key_name = "ids_management"

	iam_instance_profile = "SplashMountainElasticSearch"

	tags {
		Name = "ids-logstash-es-head.prod.us-west2.justin.tv"
	}

	ebs_optimized = true
	block_device {
		device_name = "/dev/sdb"
		volume_type = "gp2"
		volume_size = 1024
		delete_on_termination = true
	}

	block_device {
		device_name = "/dev/sdc"
		volume_type = "gp2"
		volume_size = 1024
		delete_on_termination = true
	}

	block_device {
		device_name = "/dev/sdd"
		volume_type = "gp2"
		volume_size = 1024
		delete_on_termination = true
	}

	block_device {
		device_name = "/dev/sde"
		volume_type = "gp2"
		volume_size = 1024
		delete_on_termination = true
	}
}

resource "aws_instance" "logstash-es" {
	count = 4
	ami = "${var.ids.elasticsearch-ami}"
	instance_type = "m3.xlarge"
	subnet_id = "${lookup(var.avail, concat("zone", count.index))}"
	security_groups = ["${aws_security_group.ids-elk.id}"]
	key_name = "ids_management"

	depends_on = ["aws_route53_record.ids-logstash-es-head"]

	iam_instance_profile = "SplashMountainElasticSearch"

	tags {
		Name = "ids-logstash-es-${count.index}.prod.us-west2.justin.tv"
	}

	ebs_optimized = true
	block_device {
		device_name = "/dev/sdb"
		volume_type = "gp2"
		volume_size = 1024
		delete_on_termination = true
	}

	block_device {
		device_name = "/dev/sdc"
		volume_type = "gp2"
		volume_size = 1024
		delete_on_termination = true
	}

	block_device {
		device_name = "/dev/sdd"
		volume_type = "gp2"
		volume_size = 1024
		delete_on_termination = true
	}

	block_device {
		device_name = "/dev/sde"
		volume_type = "gp2"
		volume_size = 1024
		delete_on_termination = true
	}
}
