package cors

import (
	"testing"
)

func TestOriginSet(t *testing.T) {
	t.Run("GetOriginMatch", func(t *testing.T) {
		const testOrigin = "testOrigin"

		t.Run("should return * if * and origin is allowed ", func(t *testing.T) {
			o := make(OriginSet)
			o.Add("*")
			o.Add(testOrigin)

			if o.GetOriginMatch(testOrigin) != "*" {
				t.Fail()
			}
		})

		t.Run("should return * if only * is allowed", func(t *testing.T) {
			o := make(OriginSet)
			o.Add("*")

			if o.GetOriginMatch(testOrigin) != "*" {
				t.Fail()
			}
		})

		t.Run("should return origin if only origin is allowed", func(t *testing.T) {
			o := make(OriginSet)
			o.Add(testOrigin)

			if o.GetOriginMatch(testOrigin) != testOrigin {
				t.Fail()
			}
		})

		t.Run("should return empty if origin is not white listed", func(t *testing.T) {
			o := make(OriginSet)

			if o.GetOriginMatch(testOrigin) != "" {
				t.Fail()
			}
		})
	})
}

func TestOriginList(t *testing.T) {
	t.Run("AsOriginSet", func(t *testing.T) {
		o := Origins("origin1 origin2", "*").AsOriginSet()

		if _, ok := o["origin1"]; !ok {
			t.Fail()
		}

		if _, ok := o["origin2"]; !ok {
			t.Fail()
		}

		if _, ok := o["*"]; !ok {
			t.Fail()
		}
	})
}
