# Package [csp](https://godoc.internal.justin.tv/code.justin.tv/infosec/csp)
```go
import "code.justin.tv/infosec/csp
```
CSP represents a header which is sent to a client, defining how resources will
be loaded by this webpage, with the intention of reducing the ability of 
threats to carry out browser-side code injections like XSS.

More details in the godoc.

```go
CSP := csp.ContentSecurityPolicy{
	Default: Self,
	Style:   csp.Sources(Self, "https://fonts.googleapis.com/*", "http://fonts.googleapis.com/*"),
	Sandbox: csp.Exceptions(AllowForms, AllowSameOrigin),
}

func ContentHandler(w http.ResponseWriter, r *http.Request) {
	w.Write([]byte("hello"))
}

//if OPTIONS happens, we block out the ContentHandler for the preflight request, so
//we don't perform an action / send data
var mainHandler = CSP.Middleware(
	http.HandlerFunc(ContentHandler))
```
