package jwt

import (
	"bytes"
	"crypto/rsa"
	"math/rand"
	"reflect"
	"strings"
	"testing"
)

var rnd = rndReader{
	rand.New(rand.NewSource(1337)),
}

var pkey *rsa.PrivateKey

type rndReader struct {
	*rand.Rand
}

func (r rndReader) Read(b []byte) (n int, err error) {
	for i := range b {
		b[i] = uint8(r.Intn(255))
		n++
	}

	return
}

var secret [2048]byte

var algorithms []Algorithm

type bodyType struct {
	A string
	B struct{ C string }
}

var body = bodyType{
	A: "hi",
	B: struct{ C string }{C: "hi2"},
}

func TestGenerationValidate(t *testing.T) {

	for _, a := range algorithms {
		var buf bytes.Buffer

		t.Logf("%s\n", a.Name())
		if _, err := Write(Header{
			Algorithm: a.Name(),
			Type:      "jwt",
		}, body, a, &buf); err != nil {
			t.Fatal(err)
		}

		t.Logf("jwt: %+q", buf.Bytes())

		var h Header
		var b bodyType

		if err := DecodeAndValidate(&h, &b, a, buf.Bytes()); err != nil {
			t.Fatalf("err: %s", err)
		}

		if !reflect.DeepEqual(b, body) {
			t.Fatal("misparse")
		}

		t.Log("\n")
	}

}

const algblobs = `eyJhbGciOiJub25lIiwidHlwIjoiand0In0=.eyJBIjoiaGkiLCJCIjp7IkMiOiJoaTIifX0=.
eyJhbGciOiJIUzI1NiIsInR5cCI6Imp3dCJ9.eyJBIjoiaGkiLCJCIjp7IkMiOiJoaTIifX0=.f0GgxOjBkA8IJhZFuERvmC87WitRqCw8dt-IbQdCi2o=
eyJhbGciOiJIUzM4NCIsInR5cCI6Imp3dCJ9.eyJBIjoiaGkiLCJCIjp7IkMiOiJoaTIifX0=.IxuYBihhT8kt_6qQ6Des-aulUlgfv9TL1YNsOKd06sGp7zxZ2d9pWWkOUQmjslol
eyJhbGciOiJIUzUxMiIsInR5cCI6Imp3dCJ9.eyJBIjoiaGkiLCJCIjp7IkMiOiJoaTIifX0=.-b-fXn1Jj7dtYngas84VOM1bvbVjt9gHZI1f8wEK-SQgju9IIjzTidAQ8xEu3ZjxYlZWLetcWa2xYEgl_y6U7Q==
eyJhbGciOiJSUzI1NiIsInR5cCI6Imp3dCJ9.eyJBIjoiaGkiLCJCIjp7IkMiOiJoaTIifX0=.upoyfCgKvRg-fd3gRqNFNxz7E2KvDlJL98ZXzBMWBx8aSoKZ66qYGFwXpHL8CvMo2I_i4zhwxKAJOc1MeCkBoX1xoPYHUwt6xqEpgLSMbrx7S3Dk_JH4HV9lt1jn3ZvawF7zIdi42QTzhKFQLV8UisXdqd2xyX3n-Cs7Yg3QF4xioWPods5UoLlMF3TZzZ9_aLEeKEUrO13yd27YJXpDc1SC96mNfiTEXr8O9iDjQKrpa_nwZNLIq_yRyTzFoETKmp2-nFUxktXLJZgzGQsTxlS27ofqJZy0qgwLNDrjRpaeI1MGINPhQWlRtDNclTTm38ZyRU8FAX00cf1SQyJGFg==
eyJhbGciOiJSUzM4NCIsInR5cCI6Imp3dCJ9.eyJBIjoiaGkiLCJCIjp7IkMiOiJoaTIifX0=.buUcSt9ZMH3HGCePqkjRQJfjvJKi2mPWIYOWf4Bi7CZEpBdxgF22LiHXO4NVWPFPv2YEWz-MoFmRB-GpB5RRalBJsX-Mo4yrgIGDYGT_Eds77HkTJ7lREXJEl-6SqddE8ghjCR5b_mCsMAnnXDtgpIrIaDufBiteNMclGrKUy1D1xpNTkijfdjn-tu-3jP833pIUt1ifnxKCFOhNmU7GEjuRy-fq_mo-KqGMZT-uP98db_gaS2iAdI2MpoIZ7rz35N3_3BNuNkOv9yknSj17_SvrMa_DmvPKJTBmYOsf6hxfdiBflehEGiwwU0CUoOou4itGthURmsCE6kU2ViaZIA==
eyJhbGciOiJSUzUxMiIsInR5cCI6Imp3dCJ9.eyJBIjoiaGkiLCJCIjp7IkMiOiJoaTIifX0=.KPVShRS7fS5KxlsCw0j1Vpvgu1NyF20Gmn1t0cwKbdRSOHgMXe48UCJu4Cx7XLseDfRO3LXjeVmts64vH-SZEyN5WlXm56aMOs9M1OTfL8kD96rAd635xH9Y5kyRXaL0Q1hb_4gs4qxtlUC4hReAxsMhuoyJSffJK3q3ncaQ7l7tUdN_m8V1zn1mhiMANA70CUsDQ5BPaCP4CwN8zO_ThvXzbhkhvyJhzAc1ZGUZJj0BivZIuUw8w9frWilcVVpE9ESOsSgBGF1V1t7I4YNHLEZ7DCAFP78rAGkcxD9L6X5tZBip4YBPy6MpOZDzXdYJCRwqUDaG9kIOWQCQKNix_g==`

func TestValidate(t *testing.T) {
	for i, s := range strings.Split(algblobs, "\n") {
		var h Header
		var b bodyType

		t.Log(algorithms[i].Name())
		if err := DecodeAndValidate(&h, &b, algorithms[i], []byte(s)); err != nil {
			t.Fatal(err)
		}

		if !reflect.DeepEqual(b, body) {
			t.Fatal("misparse")
		}

	}
}

func TestCanonicalizeB64(t *testing.T) {
	if c, err := canonicalizeb64([]byte("eyJleHAiOjMyNTMzOTIwMDAwLCJuYmYiOjc1NjA4NjQwMCwiaWF0IjoxNDUwMzEwNDAwLCJQcm4iOiJqb2UifQ")); !bytes.Equal(c, []byte("eyJleHAiOjMyNTMzOTIwMDAwLCJuYmYiOjc1NjA4NjQwMCwiaWF0IjoxNDUwMzEwNDAwLCJQcm4iOiJqb2UifQ==")) || err != nil {
		t.Fatalf("%+q", c)
	}
}

func init() {
	if err := initVars(); err != nil {
		panic(err)
	}
}

func initVars() (err error) {
	if pkey, err = rsa.GenerateKey(rnd, 2048); err != nil {
		return
	}

	if err = pkey.Validate(); err != nil {
		return
	}

	if _, err = rnd.Read(secret[:]); err != nil {
		return
	}

	algorithms = []Algorithm{
		//no sig
		None,
		//symm
		HS256(secret[:]),
		HS384(secret[:]),
		HS512(secret[:]),
		//asymm
		RS256(pkey),
		RS384(pkey),
		RS512(pkey),
	}

	return
}
