package jwt_test

import (
	"fmt"

	"code.justin.tv/infosec/jwt"
)

var rsaValidateAlg jwt.Algorithm

func init() {
	k, err := jwt.ReadRSAPublicKey("_key/id_rsa.pub.pem")
	if err != nil {
		panic(err)
	}

	rsaValidateAlg = jwt.RSAValidateOnly(jwt.RS256, k)
}

//RSAValidateOnly allows public key crypto (RS* family functions) to be used with only a public key.
func Example_rSAValidateOnly() {
	const rsajwt = "eyJhbGciOiJSUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIxMjM0NTY3ODkwIiwibmFtZSI6ImhpIGZ1dHVyZSBwZXJzb24hIiwiYWRtaW4iOnRydWV9.IpgD6sBJHjxlUR9rvN-9WLAqcA0RkmPBZYR-HwrB9hjS_RvrO86cfnEdYM_SftY2CwJrhGakXBrLUI36l35UW7D2TJT7tDw5YVX4YVLandZtpJVeKu_mMTYsP_cfXjAQv_q420b_G69FJyH99gLFRXkP7Be9KgpiNfbavL5FKgBCmzpeWl_8cRkhvzf06Cc3QlFQ3wvknprkfSv7NLVxUjlpHnqepX7-U_lwz0OTo64iVnjPHOEzLXdrONJf6B38kKaCN4oZRr3QnOIOFQzOB0n7Yuk1QEWepXjxyrYFbdyr7E3mh48hceSis9mCQ-cNwhD6aI6B_qf-wptUyPdYAg"
	f, err := jwt.Parse([]byte(rsajwt))
	if err != nil {
		panic(err)
	}

	if err = f.Validate(rsaValidateAlg); err != nil {
		panic(err)
	}

	fmt.Println("OK")

	//Output:
	//OK
}
