# piper-service

API endpoints to access reports generated by [piper](https://git-aws.internal.justin.tv/insights/piper). See [api/api.go](api/api.go) to see the available endpoints.

The API is meant to be accessed with the Go client that depends on [twitchclient](https://git-aws.internal.justin.tv/foundation/twitchclient). See [client/client.go](client/client.go) for all available methods.

You could access piper-service via:

- Staging - https://staging.piper-service.twitch.a2z.com/
- Production - https://prod.piper-service.twitch.a2z.com/

## Vendor Management

We use [dep](https://golang.github.io/dep/) to manage our dependencies, if you want to add more dependencies to piper-service, there are two ways suggested:

- `dep ensure -add <your_new_dependency>`
- Manually edit Gokpg.toml and run `dep ensure` to catch vendor changes up

You would love to run `dep ensure -update <package_name>` to update dependencies and `dep check` to see things out of sync. You might see `vendor-new` already exists, then you need to  `rm -rf .vendor-new` to clean up your workspace for dep ensure command.

It is not recommended to use `dep ensure -update` which will check all dependencies and try to update them all. Updating a specific one as needed, is at most times, the best way.

For more information, please read through [daily dep](https://golang.github.io/dep/docs/daily-dep.html).

## API

For a list of endpoints, [check the documentation](doc/endpoints.md).

## OnCall Runbook

See [doc/runbook.md](doc/runbook.md).

## Automated Testing

Unit tests are run as part of the CI build.

```sh
make ci
```

### Testing Continuous Improvement

* Don't release code with broken or indeterministic tests.
* Don't add new code without adding tests for it.
* Don't modify existing code without updating the existing tests or adding tests if none exists.

Please double check this when making or reviewing a Pull Request. This means that every .go file should have a respective `_test.go` file with unit tests that mock dependencies and verify the behavior of each function or method with different inputs, not only for the success cases (happy path) but also for the possible errors. If testing a unit of code is too hard, that is a sign that some refactoring is neccessary to decouple complex components. If doing that falls outside of the scope of the current task, make sure to at least file a JIRA ticket for OE improvements.

## Start local server

```sh
make run_staging
```

You need access to our AWS accounts. For Sandstorm, you need to add yourself to ldap to be able to assume role `piper-airflow-staging` then you should be able to run it.

## API Cron Testing

We are using [Runscope](https://www.runscope.com/radar/zxfkjzsyhkh8/f90da068-d231-467c-92f3-aceaced5bf4e/overview) for scheduled public insights API testings. All available Piper-Service APIs will be called every one hour for health check, if you would like to manually run, please visit the [dashboard](https://www.runscope.com/radar/zxfkjzsyhkh8/f90da068-d231-467c-92f3-aceaced5bf4e/overview) or programmatically trigger with url https://api.runscope.com/radar/bdef56a6-84e4-4565-b8a0-047ad23e9aa4/trigger.

Alerts for cron tests failure will fire to insights-alert after twice. There might be false positive since we are using a testing account, so no pager duty is hooked at the current moment.

## E2E Tests

We have [E2E tests](https://git-aws.internal.justin.tv/insights/piper-service/tree/master/tools/integration) enabled during build which runs over available endpoints for games, mods and extensions report feature.

You could manually run the integration test locally by using

```
make e2e-test-only
```

## Terraform

Similar to piper, See Terraform section in the [README file](https://git-aws.internal.justin.tv/insights/piper#terraform-infra).

With the right version of the terraform command, access to the right AWS accounts and tvars, go to the folder for the environment (e.g. `cd terraform/staging`) and run `sh bootstrap.sh` to initialize state. Then run `terraform plan --out="plan.txt"` and `terraform apply "plan.txt"`.

## Metrics Migration Guide

- [Video orgs doc for migration](https://docs.google.com/document/d/1XjcBbZvpOVXCEpnmKdpmFp4xgJTF-FUMVqVCXjRfEk4/edit#heading=h.86xsie7z2x5e)
- [Twitch Communities TwitchTelemetry Migration](https://docs.google.com/document/d/1V5E8bEhjniEbyhY4K8u4rA2nnCTz5J29o6jN3CKO8OE)

## Other

Go to [piper](https://git-aws.internal.justin.tv/insights/piper) for details on other development topics like AWS accounts, Sandstorm, Terraform, Docker, Databases, etc.

## Deploy

Use [Clean Deploy](https://clean-deploy.internal.justin.tv/#/insights/piper-service)
````
