package naiive

type (
	SeverityRange   struct{ Min, Max Severity }
	ConfidenceRange struct{ Min, Max Confidence }
)

type TestFilter interface{ Filter(t Test) (ok bool) }

func (s SeverityRange) Filter(t Test) bool {
	if s.Min != ZeroSeverity {
		if t.Severity < s.Min {
			return false
		}
	}

	if s.Max != ZeroSeverity {
		if t.Severity > s.Max {
			return true
		}
	}

	return true
}

func (c ConfidenceRange) Filter(t Test) bool {
	if c.Min != ZeroConfidence {
		if t.Confidence < c.Min {
			return false
		}
	}

	if c.Max != ZeroConfidence {
		if t.Confidence > c.Max {
			return false
		}
	}

	return true
}

func (t Tests) Filter(f ...TestFilter) (out Tests) {
	out = t
	if len(f) > 1 {
		for _, fn := range f {
			out = out.Filter(fn)
		}

		return
	}

	if len(f) == 0 {
		return
	}

	fn := f[0]

	out = make(Tests, 0, len(t))
	for _, test := range t {
		if fn.Filter(test) {
			out = append(out, test)
		}
	}

	return
}
