package api

import (
	"net/http"

	"code.justin.tv/insights/piper-service/models"
	"goji.io/pat"
	"golang.org/x/net/context"
)

func (s *Server) CreateUploadServiceRequest(ctx context.Context, r *http.Request) (interface{}, error) {
	userID := betterformat(pat.Param(r, "userid"))
	gameID := betterformat(pat.Param(r, "game"))

	// Track downloading event for BoxArt Image Upload
	trackingEvent := models.SpadeEvent{
		UserID:       userID,
		DomainID:     gameID,
		ClientID:     r.Header.Get("Twitch-Client-ID"),
		IsFirstParty: true,
		Action:       "upload_boxart_image",
		IfSucceed:    false,
	}

	ok, err := s.gamesBackend.UserOwnsGame(ctx, userID, gameID)
	if !ok || err != nil {
		s.reportTracking(ctx, trackingEvent, trackingGamesBackend, err)
		return "", err
	}

	result, err := s.gamesBackend.CreateUploadServiceRequest(ctx, userID, gameID, s.piperConfig)

	if err != nil {
		s.reportTracking(ctx, trackingEvent, trackingGamesBackend, err)
		return nil, err
	}

	s.reportTracking(ctx, trackingEvent, trackingGamesBackend, nil)

	return &models.BoxArtUploadResp{Key: *result}, nil
}
