package api

import (
	"net/http"

	"goji.io/pat"
	"golang.org/x/net/context"

	"code.justin.tv/insights/piper-service/models"
)

func (s *Server) GetDropReportLatest(ctx context.Context, r *http.Request) (interface{}, error) {
	userID := betterformat(pat.Param(r, "user_id"))
	resourceID := betterformat(pat.Param(r, "resource_id"))
	reportType := betterformat(pat.Param(r, "report_type"))

	orgID := r.URL.Query().Get("org_id")

	// event to track usage
	trackingEvent := models.SpadeEvent{
		UserID:       userID,
		DomainID:     resourceID,
		ReportID:     reportType,
		ClientID:     r.Header.Get("Twitch-Client-ID"),
		IsFirstParty: true,
		Action:       "get_drop_report_download_url",
		IfSucceed:    false,
	}

	url, err := s.dropsBackend.GetDropReportURL(ctx, userID, resourceID, reportType, orgID, s.piperConfig)

	s.reportTracking(ctx, trackingEvent, trackingDropsBackend, err)
	if err != nil {
		return nil, err
	}

	result := wrapResults("url", url)
	return result, nil
}
