package api

import (
	"net/http"

	"code.justin.tv/insights/piper-service/models"
	"goji.io/pat"
	"golang.org/x/net/context"
)

func (s *Server) GetExtensionReportTypes(ctx context.Context, r *http.Request) (interface{}, error) {
	userID := betterformat(pat.Param(r, "user_id"))
	extensionID := betterformat(pat.Param(r, "extension_id"))

	// track staff get report types usage
	trackingEvent := models.SpadeEvent{
		UserID:       userID,
		DomainID:     extensionID,
		ClientID:     r.Header.Get("Twitch-Client-ID"),
		IsFirstParty: true,
		Action:       "get_extension_report_types",
		IfSucceed:    false,
	}

	var err error
	ok, err := s.extensionsBackend.UserCanAccess(ctx, userID, extensionID)
	if !ok || err != nil {
		s.reportTracking(ctx, trackingEvent, trackingExtensionsBackend, err)
		return nil, err
	}

	result, err := s.extensionsBackend.GetReportTypes(ctx, userID, extensionID, s.piperConfig)
	if err != nil {
		s.reportTracking(ctx, trackingEvent, trackingExtensionsBackend, err)
		return nil, err
	}

	s.reportTracking(ctx, trackingEvent, trackingExtensionsBackend, nil)

	return &models.ReportTypeResp{Key: *result}, nil
}

func (s *Server) GetExtensionReportInstancesOrByDates(ctx context.Context, r *http.Request) (interface{}, error) {
	userID := betterformat(pat.Param(r, "user_id"))
	extensionID := betterformat(pat.Param(r, "extension_id"))
	reportType := betterformat(pat.Param(r, "report_type"))

	startDate := r.URL.Query().Get("start_date")
	endDate := r.URL.Query().Get("end_date")

	trackingEvent := models.SpadeEvent{
		UserID:       userID,
		DomainID:     extensionID,
		ClientID:     r.Header.Get("Twitch-Client-ID"),
		IsFirstParty: true,
		Action:       "download_extension_report",
		StartDateStr: startDate,
		EndDateStr:   endDate,
		IfSucceed:    false,
	}

	ok, err := s.extensionsBackend.UserCanAccess(ctx, userID, extensionID)
	if !ok || err != nil {
		s.reportTracking(ctx, trackingEvent, trackingExtensionsBackend, err)
		return nil, err
	}

	url, err := s.extensionsBackend.GetReportByDate(ctx, extensionID, reportType, startDate, endDate, s.piperConfig)
	if err != nil {
		s.reportTracking(ctx, trackingEvent, trackingExtensionsBackend, err)
		return "", err
	}

	s.reportTracking(ctx, trackingEvent, trackingExtensionsBackend, nil)

	wrapped := wrapResults("url", url)

	return wrapped, nil
}
